/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private final Object value;

    public JsonPrimitive(Boolean bl) {
        this.value = $Gson$Preconditions.checkNotNull(bl);
    }

    public JsonPrimitive(Number number) {
        this.value = $Gson$Preconditions.checkNotNull(number);
    }

    public JsonPrimitive(String string) {
        this.value = $Gson$Preconditions.checkNotNull(string);
    }

    private static boolean isIntegral(JsonPrimitive object) {
        object = ((JsonPrimitive)object).value;
        if (object instanceof Number) {
            return (object = (Number)object) instanceof BigInteger || object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte;
        }
        return false;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean getAsBoolean() {
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        return Boolean.parseBoolean(this.getAsString());
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public Number getAsNumber() {
        Number number;
        Object object = ((JsonPrimitive)object).value;
        if (object instanceof String) {
            LazilyParsedNumber lazilyParsedNumber;
            number = lazilyParsedNumber;
            lazilyParsedNumber = new LazilyParsedNumber((String)object);
        } else {
            number = (Number)object;
        }
        return number;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public String getAsString() {
        if (this.isNumber()) {
            return this.getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return ((Boolean)this.value).toString();
        }
        return (String)this.value;
    }

    public double getAsDouble() {
        return this.isNumber() ? this.getAsNumber().doubleValue() : Double.parseDouble(this.getAsString());
    }

    public long getAsLong() {
        return this.isNumber() ? this.getAsNumber().longValue() : Long.parseLong(this.getAsString());
    }

    @Override
    public int getAsInt() {
        return this.isNumber() ? this.getAsNumber().intValue() : Integer.parseInt(this.getAsString());
    }

    public int hashCode() {
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            long l = this.getAsNumber().longValue();
            return (int)(l ^ l >>> 32);
        }
        Object object = this.value;
        if (object instanceof Number) {
            long l = Double.doubleToLongBits(this.getAsNumber().doubleValue());
            return (int)(l ^ l >>> 32);
        }
        return object.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && JsonPrimitive.class == object.getClass()) {
            object = (JsonPrimitive)object;
            if (this.value == null) {
                return ((JsonPrimitive)object).value == null;
            }
            if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral((JsonPrimitive)object)) {
                return this.getAsNumber().longValue() == ((JsonPrimitive)object).getAsNumber().longValue();
            }
            Object object2 = this.value;
            if (object2 instanceof Number && ((JsonPrimitive)object).value instanceof Number) {
                double d;
                double d2 = this.getAsNumber().doubleValue();
                return d2 == (d = ((JsonPrimitive)object).getAsNumber().doubleValue()) || Double.isNaN(d2) && Double.isNaN(d);
            }
            return object2.equals(((JsonPrimitive)object).value);
        }
        return false;
    }
}

