/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.InstanceCreator;
import com.google.gson.internal.ConstructorConstructor$1;
import com.google.gson.internal.ConstructorConstructor$10;
import com.google.gson.internal.ConstructorConstructor$11;
import com.google.gson.internal.ConstructorConstructor$12;
import com.google.gson.internal.ConstructorConstructor$13;
import com.google.gson.internal.ConstructorConstructor$14;
import com.google.gson.internal.ConstructorConstructor$15;
import com.google.gson.internal.ConstructorConstructor$16;
import com.google.gson.internal.ConstructorConstructor$17;
import com.google.gson.internal.ConstructorConstructor$2;
import com.google.gson.internal.ConstructorConstructor$3;
import com.google.gson.internal.ConstructorConstructor$4;
import com.google.gson.internal.ConstructorConstructor$5;
import com.google.gson.internal.ConstructorConstructor$6;
import com.google.gson.internal.ConstructorConstructor$7;
import com.google.gson.internal.ConstructorConstructor$8;
import com.google.gson.internal.ConstructorConstructor$9;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;

public final class ConstructorConstructor {
    private final Map instanceCreators;
    private final boolean useJdkUnsafe;

    public ConstructorConstructor(Map map, boolean bl) {
        this.instanceCreators = map;
        this.useJdkUnsafe = bl;
    }

    private ObjectConstructor newDefaultConstructor(Class genericDeclaration) {
        if (Modifier.isAbstract(genericDeclaration.getModifiers())) {
            return null;
        }
        try {
            genericDeclaration = genericDeclaration.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        String string = ReflectionHelper.tryMakeAccessible(genericDeclaration);
        if (string != null) {
            return new ConstructorConstructor$3(this, string);
        }
        return new ConstructorConstructor$4(this, (Constructor)genericDeclaration);
    }

    private ObjectConstructor newDefaultImplementationConstructor(Type type2, Class clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$5(this);
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$6(this, type2);
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$7(this);
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$8(this);
            }
            return new ConstructorConstructor$9(this);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (clazz == EnumMap.class) {
                return new ConstructorConstructor$10(this, type2);
            }
            if (ConcurrentNavigableMap.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$11(this);
            }
            if (ConcurrentMap.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$12(this);
            }
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$13(this);
            }
            if (type2 instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type2).getActualTypeArguments()[0]).getRawType())) {
                return new ConstructorConstructor$14(this);
            }
            return new ConstructorConstructor$15(this);
        }
        return null;
    }

    private ObjectConstructor newUnsafeAllocator(Class object) {
        if (this.useJdkUnsafe) {
            return new ConstructorConstructor$16(this, (Class)object);
        }
        object = "Unable to create instance of " + object + "; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.";
        return new ConstructorConstructor$17(this, (String)object);
    }

    public ObjectConstructor get(TypeToken object) {
        TypeToken typeToken = object;
        object = typeToken.getType();
        Class clazz = typeToken.getRawType();
        Object object2 = (InstanceCreator)this.instanceCreators.get(object);
        if (object2 != null) {
            return new ConstructorConstructor$1(this, (InstanceCreator)object2, (Type)object);
        }
        object2 = (InstanceCreator)this.instanceCreators.get(clazz);
        if (object2 != null) {
            return new ConstructorConstructor$2(this, (InstanceCreator)object2, (Type)object);
        }
        object2 = this.newDefaultConstructor(clazz);
        if (object2 != null) {
            return object2;
        }
        if ((object = this.newDefaultImplementationConstructor((Type)object, clazz)) != null) {
            return object;
        }
        return this.newUnsafeAllocator(clazz);
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

