/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

public abstract class JavaVersion {
    private static final int majorJavaVersion = JavaVersion.determineMajorJavaVersion();

    private static int determineMajorJavaVersion() {
        return JavaVersion.getMajorJavaVersion(System.getProperty("java.version"));
    }

    static int getMajorJavaVersion(String string) {
        int n = JavaVersion.parseDotted(string);
        if (n == -1) {
            n = JavaVersion.extractBeginningInt(string);
        }
        if (n == -1) {
            return 6;
        }
        return n;
    }

    private static int parseDotted(String stringArray) {
        int n;
        block5: {
            try {
                stringArray = stringArray.split("[._]");
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            n = Integer.parseInt(stringArray[0]);
            if (n != 1) break block5;
            if (stringArray.length <= 1) break block5;
            return Integer.parseInt(stringArray[1]);
        }
        return n;
    }

    private static int extractBeginningInt(String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            if (n >= string.length()) break;
            char c = string.charAt(n);
            if (!Character.isDigit(c)) break;
            stringBuilder2.append(c);
            ++n;
        }
        try {
            return Integer.parseInt(stringBuilder2.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static boolean isJava9OrLater() {
        return majorJavaVersion >= 9;
    }
}

