/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.DateTypeAdapter$1;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class DateTypeAdapter
extends TypeAdapter {
    public static final TypeAdapterFactory FACTORY = new DateTypeAdapter$1();
    private final List dateFormats;

    public DateTypeAdapter() {
        ArrayList<DateFormat> arrayList;
        ArrayList<DateFormat> arrayList2;
        ArrayList<DateFormat> arrayList3 = arrayList2 = arrayList;
        arrayList3();
        ((DateTypeAdapter)((Object)locale)).dateFormats = arrayList3;
        Locale locale = Locale.US;
        arrayList.add(DateFormat.getDateTimeInstance(2, 2, locale));
        if (!Locale.getDefault().equals(locale)) {
            arrayList2.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.isJava9OrLater()) {
            arrayList2.add(PreJava9DateFormatProvider.getUSDateTimeFormat(2, 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date deserializeToDate(JsonReader jsonReader) {
        Object object;
        String string;
        DateTypeAdapter dateTypeAdapter = string;
        string = jsonReader.nextString();
        List list = dateTypeAdapter.dateFormats;
        synchronized (list) {
            Iterator iterator2 = dateTypeAdapter.dateFormats.iterator();
            while (iterator2.hasNext()) {
                try {
                    return ((DateFormat)iterator2.next()).parse(string);
                }
                catch (ParseException parseException) {
                }
            }
            {
                object = string;
            }
        }
        try {
            return ISO8601Utils.parse((String)object, new ParsePosition(0));
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException("Failed parsing '" + (String)string + "' as Date; at path " + jsonReader.getPreviousPath(), parseException);
        }
    }

    @Override
    public Date read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return this.deserializeToDate(jsonReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(JsonWriter object, Date date) {
        Object object2;
        if (date == null) {
            ((JsonWriter)object).nullValue();
            return;
        }
        Object object3 = object;
        DateTypeAdapter dateTypeAdapter = object2;
        object2 = (DateFormat)dateTypeAdapter.dateFormats.get(0);
        object = dateTypeAdapter.dateFormats;
        synchronized (object) {
            object2 = ((DateFormat)object2).format(date);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : object
            ((JsonWriter)object3).value((String)object2);
            return;
        }
    }
}

