/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.bind.JsonTreeReader$1;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader UNREADABLE_READER = new JsonTreeReader$1();
    private static final Object SENTINEL_CLOSED = new Object();
    private Object[] stack = new Object[32];
    private int stackSize = 0;
    private String[] pathNames = new String[32];
    private int[] pathIndices = new int[32];

    public JsonTreeReader(JsonElement jsonElement) {
        super(UNREADABLE_READER);
        this.push(jsonElement);
    }

    private Object peekStack() {
        return this.stack[this.stackSize - 1];
    }

    private Object popStack() {
        int n;
        Object[] objectArray = this.stack;
        this.stackSize = n = this.stackSize - 1;
        objectArray[n] = null;
        return this.stack[n];
    }

    private void expect(JsonToken jsonToken) {
        if (this.peek() == jsonToken) {
            return;
        }
        throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    private void push(Object object) {
        int n = this.stackSize;
        Object[] objectArray = this.stack;
        if (n == this.stack.length) {
            JsonTreeReader jsonTreeReader = this;
            jsonTreeReader.stack = Arrays.copyOf(objectArray, n *= 2);
            jsonTreeReader.pathIndices = Arrays.copyOf(jsonTreeReader.pathIndices, n);
            jsonTreeReader.pathNames = Arrays.copyOf(jsonTreeReader.pathNames, n);
        }
        int n2 = this.stackSize;
        this.stackSize = n2 + 1;
        this.stack[n2] = object;
    }

    private String getPath(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder().append('$');
        for (int i = 0; i < (n = this.stackSize); ++i) {
            Object[] objectArray = this.stack;
            Object object = this.stack[i];
            if (object instanceof JsonArray) {
                if (++i >= n || !(objectArray[i] instanceof Iterator)) continue;
                int n2 = this.pathIndices[i];
                if (bl && n2 > 0 && (i == n - 1 || i == n - 2)) {
                    --n2;
                }
                stringBuilder.append('[').append(n2).append(']');
                continue;
            }
            if (!(object instanceof JsonObject) || ++i >= n || !(objectArray[i] instanceof Iterator)) continue;
            stringBuilder.append('.');
            String string = this.pathNames[i];
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String locationString() {
        return " at path " + this.getPath();
    }

    @Override
    public void beginArray() {
        JsonTreeReader jsonTreeReader = this;
        jsonTreeReader.expect(JsonToken.BEGIN_ARRAY);
        jsonTreeReader.push(((JsonArray)jsonTreeReader.peekStack()).iterator());
        jsonTreeReader.pathIndices[this.stackSize - 1] = 0;
    }

    @Override
    public void endArray() {
        JsonTreeReader jsonTreeReader = this;
        jsonTreeReader.expect(JsonToken.END_ARRAY);
        jsonTreeReader.popStack();
        jsonTreeReader.popStack();
        int n = jsonTreeReader.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
    }

    @Override
    public void beginObject() {
        JsonTreeReader jsonTreeReader = this;
        jsonTreeReader.expect(JsonToken.BEGIN_OBJECT);
        jsonTreeReader.push(((JsonObject)jsonTreeReader.peekStack()).entrySet().iterator());
    }

    @Override
    public void endObject() {
        JsonTreeReader jsonTreeReader = this;
        jsonTreeReader.expect(JsonToken.END_OBJECT);
        jsonTreeReader.popStack();
        jsonTreeReader.popStack();
        int n = jsonTreeReader.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
    }

    @Override
    public boolean hasNext() {
        JsonToken jsonToken = this.peek();
        return jsonToken != JsonToken.END_OBJECT && jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_DOCUMENT;
    }

    @Override
    public JsonToken peek() {
        if (((JsonTreeReader)((Object)jsonPrimitive)).stackSize == 0) {
            return JsonToken.END_DOCUMENT;
        }
        Object object = ((JsonTreeReader)((Object)jsonPrimitive)).peekStack();
        if (object instanceof Iterator) {
            boolean bl = ((JsonTreeReader)((Object)jsonPrimitive)).stack[((JsonTreeReader)((Object)jsonPrimitive)).stackSize - 2] instanceof JsonObject;
            Iterator iterator2 = (Iterator)object;
            if (iterator2.hasNext()) {
                if (bl) {
                    return JsonToken.NAME;
                }
                JsonPrimitive jsonPrimitive = jsonPrimitive;
                super.push(iterator2.next());
                return ((JsonTreeReader)((Object)jsonPrimitive)).peek();
            }
            return bl ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
        }
        if (object instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (object instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (object instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
            if (jsonPrimitive.isString()) {
                return JsonToken.STRING;
            }
            if (jsonPrimitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (jsonPrimitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (object instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (object == SENTINEL_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw new AssertionError();
    }

    @Override
    public String nextName() {
        String string;
        JsonTreeReader jsonTreeReader = this;
        jsonTreeReader.expect(JsonToken.NAME);
        Map.Entry entry = (Map.Entry)((Iterator)jsonTreeReader.peekStack()).next();
        this.pathNames[this.stackSize - 1] = string = (String)entry.getKey();
        this.push(entry.getValue());
        return string;
    }

    @Override
    public String nextString() {
        JsonToken jsonToken;
        Object object = this.peek();
        if (object != (jsonToken = JsonToken.STRING) && object != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)object + this.locationString());
        }
        JsonTreeReader jsonTreeReader = this;
        object = ((JsonPrimitive)jsonTreeReader.popStack()).getAsString();
        int n = jsonTreeReader.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
        return object;
    }

    @Override
    public boolean nextBoolean() {
        JsonTreeReader jsonTreeReader = this;
        jsonTreeReader.expect(JsonToken.BOOLEAN);
        boolean bl = ((JsonPrimitive)jsonTreeReader.popStack()).getAsBoolean();
        int n = jsonTreeReader.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
        return bl;
    }

    @Override
    public void nextNull() {
        JsonTreeReader jsonTreeReader = this;
        jsonTreeReader.expect(JsonToken.NULL);
        jsonTreeReader.popStack();
        int n = jsonTreeReader.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
    }

    @Override
    public double nextDouble() {
        JsonToken jsonToken;
        JsonToken jsonToken2 = this.peek();
        if (jsonToken2 != (jsonToken = JsonToken.NUMBER) && jsonToken2 != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)jsonToken2) + this.locationString());
        }
        JsonTreeReader jsonTreeReader = this;
        double d = ((JsonPrimitive)jsonTreeReader.peekStack()).getAsDouble();
        if (!jsonTreeReader.isLenient() && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new NumberFormatException("JSON forbids NaN and infinities: " + d);
        }
        JsonTreeReader jsonTreeReader2 = this;
        jsonTreeReader2.popStack();
        int n = jsonTreeReader2.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
        return d;
    }

    @Override
    public long nextLong() {
        JsonToken jsonToken;
        JsonToken jsonToken2 = this.peek();
        if (jsonToken2 != (jsonToken = JsonToken.NUMBER) && jsonToken2 != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)jsonToken2) + this.locationString());
        }
        JsonTreeReader jsonTreeReader = this;
        long l = ((JsonPrimitive)jsonTreeReader.peekStack()).getAsLong();
        jsonTreeReader.popStack();
        int n = jsonTreeReader.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
        return l;
    }

    @Override
    public int nextInt() {
        JsonToken jsonToken;
        JsonToken jsonToken2 = this.peek();
        if (jsonToken2 != (jsonToken = JsonToken.NUMBER) && jsonToken2 != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)jsonToken2) + this.locationString());
        }
        JsonTreeReader jsonTreeReader = this;
        int n = ((JsonPrimitive)jsonTreeReader.peekStack()).getAsInt();
        jsonTreeReader.popStack();
        int n2 = jsonTreeReader.stackSize;
        if (n2 > 0) {
            int n3 = n2 - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
        }
        return n;
    }

    JsonElement nextJsonElement() {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NAME && jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_OBJECT && jsonToken != JsonToken.END_DOCUMENT) {
            JsonElement jsonElement = (JsonElement)this.peekStack();
            this.skipValue();
            return jsonElement;
        }
        throw new IllegalStateException("Unexpected " + (Object)((Object)jsonToken) + " when reading a JsonElement.");
    }

    @Override
    public void close() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = SENTINEL_CLOSED;
        objectArray2.stack = objectArray2;
        objectArray2.stackSize = 1;
    }

    @Override
    public void skipValue() {
        int n;
        if (this.peek() == JsonToken.NAME) {
            JsonTreeReader jsonTreeReader = this;
            jsonTreeReader.nextName();
            jsonTreeReader.pathNames[this.stackSize - 2] = "null";
        } else {
            JsonTreeReader jsonTreeReader = this;
            jsonTreeReader.popStack();
            n = jsonTreeReader.stackSize;
            if (n > 0) {
                this.pathNames[n - 1] = "null";
            }
        }
        n = this.stackSize;
        if (n > 0) {
            int n2 = n - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
    }

    @Override
    public String toString() {
        return JsonTreeReader.class.getSimpleName() + this.locationString();
    }

    public void promoteNameToValue() {
        JsonTreeReader jsonTreeReader = entry;
        jsonTreeReader.expect(JsonToken.NAME);
        Map.Entry entry = (Map.Entry)((Iterator)jsonTreeReader.peekStack()).next();
        jsonTreeReader.push(entry.getValue());
        jsonTreeReader.push(new JsonPrimitive((String)entry.getKey()));
    }

    @Override
    public String getPreviousPath() {
        return this.getPath(true);
    }

    @Override
    public String getPath() {
        return this.getPath(false);
    }
}

