/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import kotlin.collections.ArraysKt;
import kotlin.collections.BrittleContainsOptimizationKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.CollectionsKt__MutableCollectionsJVMKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.IntRange;

abstract class CollectionsKt__MutableCollectionsKt
extends CollectionsKt__MutableCollectionsJVMKt {
    public static boolean addAll(Collection collection, Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        Intrinsics.checkNotNullParameter(iterable2, "elements");
        if (iterable2 instanceof Collection) {
            return collection.addAll((Collection)iterable);
        }
        boolean bl = false;
        Iterator iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            if (!collection.add(iterator2.next())) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean addAll(Collection collection, Object[] objectArray) {
        Intrinsics.checkNotNullParameter(collection, "<this>");
        Intrinsics.checkNotNullParameter(objectArray, "elements");
        return collection.addAll(ArraysKt.asList(objectArray));
    }

    public static final boolean retainAll(Collection collection, Iterable iterable) {
        Collection collection2 = collection;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        Intrinsics.checkNotNullParameter(iterable, "elements");
        collection = BrittleContainsOptimizationKt.convertToSetForSetOperationWith(iterable, collection);
        return TypeIntrinsics.asMutableCollection(collection2).retainAll(collection);
    }

    public static boolean removeAll(Iterable iterable, Function1 function1) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(function12, "predicate");
        return CollectionsKt__MutableCollectionsKt.filterInPlace$CollectionsKt__MutableCollectionsKt(iterable, function12, true);
    }

    private static final boolean filterInPlace$CollectionsKt__MutableCollectionsKt(Iterable iterable, Function1 function1, boolean bl) {
        boolean bl2 = false;
        Iterator iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            if ((Boolean)function1.invoke(iterator2.next()) != bl) continue;
            iterator2.remove();
            bl2 = true;
        }
        return bl2;
    }

    public static Object removeLastOrNull(List list) {
        Object v1;
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        if (list2.isEmpty()) {
            v1 = null;
        } else {
            List list3 = list;
            v1 = list3.remove(CollectionsKt.getLastIndex(list3));
        }
        return v1;
    }

    public static boolean removeAll(List list, Function1 function1) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter(list, "<this>");
        Intrinsics.checkNotNullParameter(function12, "predicate");
        return CollectionsKt__MutableCollectionsKt.filterInPlace$CollectionsKt__MutableCollectionsKt(list, function12, true);
    }

    private static final boolean filterInPlace$CollectionsKt__MutableCollectionsKt(List list, Function1 function1, boolean bl) {
        if (!(list instanceof RandomAccess)) {
            List list2 = list;
            Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.MutableIterable<T of kotlin.collections.CollectionsKt__MutableCollectionsKt.filterInPlace>");
            return CollectionsKt__MutableCollectionsKt.filterInPlace$CollectionsKt__MutableCollectionsKt(TypeIntrinsics.asMutableIterable(list2), function1, bl);
        }
        int n = 0;
        IntIterator intIterator = new IntRange(0, CollectionsKt.getLastIndex(list)).iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.nextInt();
            Object e = list.get(n2);
            if ((Boolean)function1.invoke(e) == bl) continue;
            if (n != n2) {
                list.set(n, e);
            }
            ++n;
        }
        if (n < list.size()) {
            int n3 = CollectionsKt.getLastIndex(list);
            if (n <= n3) {
                while (true) {
                    list.remove(n3);
                    if (n3 == n) break;
                    --n3;
                }
            }
            return true;
        }
        return false;
    }
}

