/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KParameter;
import kotlin.reflect.KParameter$Kind;
import kotlin.reflect.KType;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.IllegalCallableAccessException;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.reflect.jvm.internal.KCallableImpl$_annotations$1;
import kotlin.reflect.jvm.internal.KCallableImpl$_parameters$1;
import kotlin.reflect.jvm.internal.KCallableImpl$_returnType$1;
import kotlin.reflect.jvm.internal.KCallableImpl$_typeParameters$1;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KTypeParameterOwnerImpl;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.ReflectProperties;
import kotlin.reflect.jvm.internal.ReflectProperties$LazySoftVal;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;

public abstract class KCallableImpl
implements KCallable,
KTypeParameterOwnerImpl {
    private final ReflectProperties$LazySoftVal _annotations;
    private final ReflectProperties$LazySoftVal _parameters;
    private final ReflectProperties$LazySoftVal _returnType;
    private final ReflectProperties$LazySoftVal _typeParameters;

    public KCallableImpl() {
        ReflectProperties$LazySoftVal reflectProperties$LazySoftVal = ReflectProperties.lazySoft(new KCallableImpl$_annotations$1((KCallableImpl)((Object)reflectProperties$LazySoftVal2)));
        Intrinsics.checkNotNullExpressionValue(reflectProperties$LazySoftVal, "lazySoft { descriptor.computeAnnotations() }");
        ((KCallableImpl)((Object)reflectProperties$LazySoftVal2))._annotations = reflectProperties$LazySoftVal;
        reflectProperties$LazySoftVal = ReflectProperties.lazySoft(new KCallableImpl$_parameters$1((KCallableImpl)((Object)reflectProperties$LazySoftVal2)));
        Intrinsics.checkNotNullExpressionValue(reflectProperties$LazySoftVal, "lazySoft {\n        val d\u2026ze()\n        result\n    }");
        ((KCallableImpl)((Object)reflectProperties$LazySoftVal2))._parameters = reflectProperties$LazySoftVal;
        reflectProperties$LazySoftVal = ReflectProperties.lazySoft(new KCallableImpl$_returnType$1((KCallableImpl)((Object)reflectProperties$LazySoftVal2)));
        Intrinsics.checkNotNullExpressionValue(reflectProperties$LazySoftVal, "lazySoft {\n        KType\u2026eturnType\n        }\n    }");
        ((KCallableImpl)((Object)reflectProperties$LazySoftVal2))._returnType = reflectProperties$LazySoftVal;
        ReflectProperties$LazySoftVal reflectProperties$LazySoftVal2 = ReflectProperties.lazySoft(new KCallableImpl$_typeParameters$1((KCallableImpl)((Object)reflectProperties$LazySoftVal2)));
        Intrinsics.checkNotNullExpressionValue(reflectProperties$LazySoftVal2, "lazySoft {\n        descr\u2026this, descriptor) }\n    }");
        v0._typeParameters = reflectProperties$LazySoftVal2;
    }

    private final Object callAnnotationConstructor(Map object) {
        ArrayList arrayList;
        Object object2 = this.getParameters();
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            KParameter kParameter;
            block12: {
                Object object3;
                block10: {
                    block11: {
                        block9: {
                            kParameter = (KParameter)object2.next();
                            if (!object.containsKey(kParameter)) break block9;
                            object3 = object.get(kParameter);
                            if (object3 == null) {
                                throw new IllegalArgumentException("Annotation argument value cannot be null (" + kParameter + ')');
                            }
                            break block10;
                        }
                        if (!kParameter.isOptional()) break block11;
                        object3 = null;
                        break block10;
                    }
                    if (!kParameter.isVararg()) break block12;
                    object3 = this.defaultEmptyArray(kParameter.getType());
                }
                arrayList2.add(object3);
                continue;
            }
            throw new IllegalArgumentException("No argument provided for a required parameter: " + kParameter);
        }
        object = this.getDefaultCaller();
        if (object != null) {
            try {
                Object[] objectArray = arrayList2.toArray(new Object[0]);
                Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                return object.call(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalCallableAccessException(illegalAccessException);
            }
        }
        throw new KotlinReflectionInternalError("This callable does not support a default call: " + this.getDescriptor());
    }

    private final Object defaultEmptyArray(KType kType) {
        Class clazz = JvmClassMappingKt.getJavaClass(KTypesJvm.getJvmErasure(kType));
        if (clazz.isArray()) {
            Object object = Array.newInstance(clazz.getComponentType(), 0);
            Intrinsics.checkNotNullExpressionValue(object, "type.jvmErasure.java.run\u2026\"\n            )\n        }");
            return object;
        }
        throw new KotlinReflectionInternalError("Cannot instantiate the default empty array of type " + clazz.getSimpleName() + ", because it is not an array type");
    }

    private final Type extractContinuationArgument() {
        CallableMemberDescriptor callableMemberDescriptor = object.getDescriptor();
        callableMemberDescriptor = callableMemberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableMemberDescriptor : null;
        if (callableMemberDescriptor != null && callableMemberDescriptor.isSuspend() && Intrinsics.areEqual((object = (object = CollectionsKt.lastOrNull(object.getCaller().getParameterTypes())) instanceof ParameterizedType ? (ParameterizedType)object : null) != null ? object.getRawType() : null, Continuation.class)) {
            Object[] objectArray = object.getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue(objectArray, "continuationType.actualTypeArguments");
            Object object = ArraysKt.single(objectArray);
            object = object instanceof WildcardType ? (WildcardType)object : null;
            return object != null && (object = object.getLowerBounds()) != null ? (Type)ArraysKt.first(object) : null;
        }
        return null;
    }

    public static final /* synthetic */ Type access$extractContinuationArgument(KCallableImpl kCallableImpl) {
        return kCallableImpl.extractContinuationArgument();
    }

    public abstract CallableMemberDescriptor getDescriptor();

    public abstract Caller getCaller();

    public abstract Caller getDefaultCaller();

    public abstract KDeclarationContainerImpl getContainer();

    public abstract boolean isBound();

    @Override
    public List getAnnotations() {
        Object object = this._annotations.invoke();
        Intrinsics.checkNotNullExpressionValue(object, "_annotations()");
        return (List)object;
    }

    @Override
    public List getParameters() {
        Object object = this._parameters.invoke();
        Intrinsics.checkNotNullExpressionValue(object, "_parameters()");
        return (List)object;
    }

    @Override
    public KType getReturnType() {
        Object object = this._returnType.invoke();
        Intrinsics.checkNotNullExpressionValue(object, "_returnType()");
        return (KType)object;
    }

    @Override
    public List getTypeParameters() {
        Object object = this._typeParameters.invoke();
        Intrinsics.checkNotNullExpressionValue(object, "_typeParameters()");
        return (List)object;
    }

    @Override
    public KVisibility getVisibility() {
        DescriptorVisibility descriptorVisibility = this.getDescriptor().getVisibility();
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "descriptor.visibility");
        return UtilKt.toKVisibility(descriptorVisibility);
    }

    @Override
    public boolean isFinal() {
        return this.getDescriptor().getModality() == Modality.FINAL;
    }

    @Override
    public boolean isOpen() {
        return this.getDescriptor().getModality() == Modality.OPEN;
    }

    @Override
    public boolean isAbstract() {
        return this.getDescriptor().getModality() == Modality.ABSTRACT;
    }

    protected final boolean isAnnotationConstructor() {
        return Intrinsics.areEqual(this.getName(), "<init>") && this.getContainer().getJClass().isAnnotation();
    }

    @Override
    public Object call(Object ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "args");
        try {
            return this.getCaller().call(objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalCallableAccessException(illegalAccessException);
        }
    }

    @Override
    public Object callBy(Map map) {
        Intrinsics.checkNotNullParameter(map, "args");
        return this.isAnnotationConstructor() ? this.callAnnotationConstructor(map) : this.callDefaultMethod$kotlin_reflection(map, null);
    }

    public final Object callDefaultMethod$kotlin_reflection(Map object, Continuation continuation) {
        ArrayList<Integer> arrayList;
        ArrayList<Object> arrayList2;
        Intrinsics.checkNotNullParameter(object, "args");
        List list = this.getParameters();
        ArrayList<Object> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Object>(list.size());
        int n = 0;
        ArrayList<Integer> arrayList4 = arrayList;
        arrayList = new ArrayList<Integer>(1);
        int n2 = 0;
        boolean bl = false;
        for (KParameter kParameter : list) {
            block13: {
                block11: {
                    block12: {
                        block10: {
                            if (n2 != 0 && n2 % 32 == 0) {
                                arrayList4.add(n);
                                n = 0;
                            }
                            if (!object.containsKey(kParameter)) break block10;
                            arrayList3.add(object.get(kParameter));
                            break block11;
                        }
                        if (!kParameter.isOptional()) break block12;
                        Object object2 = UtilKt.isInlineClassType(kParameter.getType()) ? null : UtilKt.defaultPrimitiveValue(ReflectJvmMapping.getJavaType(kParameter.getType()));
                        arrayList3.add(object2);
                        n |= 1 << n2 % 32;
                        bl = true;
                        break block11;
                    }
                    if (!kParameter.isVararg()) break block13;
                    arrayList3.add(this.defaultEmptyArray(kParameter.getType()));
                }
                if (kParameter.getKind() != KParameter$Kind.VALUE) continue;
                ++n2;
                continue;
            }
            throw new IllegalArgumentException("No argument provided for a required parameter: " + kParameter);
        }
        if (continuation != null) {
            arrayList3.add(continuation);
        }
        if (!bl) {
            Object[] objectArray = arrayList3.toArray(new Object[0]);
            Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            return this.call(Arrays.copyOf(objectArray, objectArray.length));
        }
        arrayList4.add(n);
        object = this.getDefaultCaller();
        if (object != null) {
            ArrayList<Object> arrayList5 = arrayList3;
            arrayList5.addAll(arrayList4);
            arrayList5.add(null);
            try {
                Object[] objectArray = arrayList5.toArray(new Object[0]);
                Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                return object.call(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalCallableAccessException(illegalAccessException);
            }
        }
        throw new KotlinReflectionInternalError("This callable does not support a default call: " + this.getDescriptor());
    }
}

