/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collections;
import java.util.List;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltInsLoader;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltInsPackageFragment;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns$1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns$2;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns$3;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns$4;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns$Primitives;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedTypes;
import kotlin.reflect.jvm.internal.impl.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.AdditionalClassPartsProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.AdditionalClassPartsProvider$None;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.PlatformDependentDeclarationFilter;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.PlatformDependentDeclarationFilter$NoPlatformDependent;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;

public abstract class KotlinBuiltIns {
    public static final Name BUILTINS_MODULE_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;
    private ModuleDescriptorImpl builtInsModule;
    private NotNullLazyValue postponedBuiltInsModule;
    private final NotNullLazyValue primitives;
    private final NotNullLazyValue builtInPackagesImportedByDefault;
    private final MemoizedFunctionToNotNull builtInClassesByName;
    private final StorageManager storageManager;

    protected KotlinBuiltIns(StorageManager storageManager) {
        if (storageManager == null) {
            KotlinBuiltIns.$$$reportNull$$$0(0);
        }
        this.storageManager = storageManager;
        this.builtInPackagesImportedByDefault = storageManager.createLazyValue(new KotlinBuiltIns$1(this));
        this.primitives = storageManager.createLazyValue(new KotlinBuiltIns$2(this));
        this.builtInClassesByName = storageManager.createMemoizedFunction(new KotlinBuiltIns$3(this));
    }

    public static boolean isBuiltIn(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(9);
        }
        return DescriptorUtils.getParentOfType(declarationDescriptor, BuiltInsPackageFragment.class, false) != null;
    }

    public static boolean isUnderKotlinPackage(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(10);
        }
        while (declarationDescriptor != null) {
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                return ((PackageFragmentDescriptor)declarationDescriptor).getFqName().startsWith(StandardNames.BUILT_INS_PACKAGE_NAME);
            }
            declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        }
        return false;
    }

    private ClassDescriptor getBuiltInClassByName(String string) {
        if (string == null) {
            KotlinBuiltIns.$$$reportNull$$$0(14);
        }
        if ((this = (ClassDescriptor)((KotlinBuiltIns)this).builtInClassesByName.invoke(Name.identifier(string))) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(15);
        }
        return this;
    }

    private ClassDescriptor getPrimitiveClassDescriptor(PrimitiveType primitiveType) {
        if (primitiveType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(16);
        }
        return this.getBuiltInClassByName(primitiveType.getTypeName().asString());
    }

    private SimpleType getBuiltInTypeByClassName(String string) {
        if (string == null) {
            KotlinBuiltIns.$$$reportNull$$$0(46);
        }
        if ((this = ((KotlinBuiltIns)this).getBuiltInClassByName(string).getDefaultType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(47);
        }
        return this;
    }

    private static KotlinType getElementTypeForUnsignedArray(KotlinType object, ModuleDescriptor moduleDescriptor) {
        if (object == null) {
            KotlinBuiltIns.$$$reportNull$$$0(71);
        }
        if (moduleDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(72);
        }
        if ((object = ((KotlinType)object).getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        UnsignedTypes unsignedTypes = UnsignedTypes.INSTANCE;
        if (!unsignedTypes.isShortNameOfUnsignedArray(object.getName())) {
            return null;
        }
        if ((object = DescriptorUtilsKt.getClassId((ClassifierDescriptor)object)) == null) {
            return null;
        }
        if ((object = unsignedTypes.getUnsignedClassIdByArrayClassId((ClassId)object)) == null) {
            return null;
        }
        if ((object = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object)) == null) {
            return null;
        }
        return object.getDefaultType();
    }

    public static PrimitiveType getPrimitiveType(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(76);
        }
        return StandardNames$FqNames.primitiveTypeShortNames.contains(declarationDescriptor.getName()) ? (PrimitiveType)((Object)StandardNames$FqNames.fqNameToPrimitiveType.get(DescriptorUtils.getFqName(declarationDescriptor))) : null;
    }

    public static PrimitiveType getPrimitiveArrayType(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(77);
        }
        return StandardNames$FqNames.primitiveArrayTypeShortNames.contains(declarationDescriptor.getName()) ? (PrimitiveType)((Object)StandardNames$FqNames.arrayClassFqNameToPrimitiveType.get(DescriptorUtils.getFqName(declarationDescriptor))) : null;
    }

    public static boolean isArray(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(88);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, StandardNames$FqNames.array);
    }

    public static boolean isArrayOrPrimitiveArray(ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(89);
        }
        return KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames$FqNames.array) || KotlinBuiltIns.getPrimitiveArrayType(classDescriptor) != null;
    }

    public static boolean isArrayOrPrimitiveArray(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(90);
        }
        return KotlinBuiltIns.isArray(kotlinType) || KotlinBuiltIns.isPrimitiveArray(kotlinType);
    }

    public static boolean isPrimitiveArray(KotlinType annotated) {
        if (annotated == null) {
            KotlinBuiltIns.$$$reportNull$$$0(91);
        }
        return (annotated = annotated.getConstructor().getDeclarationDescriptor()) != null && KotlinBuiltIns.getPrimitiveArrayType((DeclarationDescriptor)annotated) != null;
    }

    public static PrimitiveType getPrimitiveArrayElementType(KotlinType annotated) {
        if (annotated == null) {
            KotlinBuiltIns.$$$reportNull$$$0(92);
        }
        return (annotated = annotated.getConstructor().getDeclarationDescriptor()) == null ? null : KotlinBuiltIns.getPrimitiveArrayType((DeclarationDescriptor)annotated);
    }

    public static boolean isPrimitiveType(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(94);
        }
        return !kotlinType.isMarkedNullable() && KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(kotlinType);
    }

    public static boolean isPrimitiveTypeOrNullablePrimitiveType(KotlinType annotated) {
        if (annotated == null) {
            KotlinBuiltIns.$$$reportNull$$$0(95);
        }
        return (annotated = annotated.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)annotated);
    }

    public static boolean isPrimitiveClass(ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(96);
        }
        return KotlinBuiltIns.getPrimitiveType(classDescriptor) != null;
    }

    private static boolean isConstructedFromGivenClass(KotlinType kotlinType, FqNameUnsafe fqNameUnsafe) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(97);
        }
        if (fqNameUnsafe == null) {
            KotlinBuiltIns.$$$reportNull$$$0(98);
        }
        return KotlinBuiltIns.isTypeConstructorForGivenClass(kotlinType.getConstructor(), fqNameUnsafe);
    }

    public static boolean isTypeConstructorForGivenClass(TypeConstructor object, FqNameUnsafe fqNameUnsafe) {
        if (object == null) {
            KotlinBuiltIns.$$$reportNull$$$0(101);
        }
        if (fqNameUnsafe == null) {
            KotlinBuiltIns.$$$reportNull$$$0(102);
        }
        return (object = object.getDeclarationDescriptor()) instanceof ClassDescriptor && KotlinBuiltIns.classFqNameEquals((ClassifierDescriptor)object, fqNameUnsafe);
    }

    private static boolean classFqNameEquals(ClassifierDescriptor classifierDescriptor, FqNameUnsafe fqNameUnsafe) {
        if (classifierDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(103);
        }
        if (fqNameUnsafe == null) {
            KotlinBuiltIns.$$$reportNull$$$0(104);
        }
        return classifierDescriptor.getName().equals(fqNameUnsafe.shortName()) && fqNameUnsafe.equals(DescriptorUtils.getFqName(classifierDescriptor));
    }

    private static boolean isNotNullConstructedFromGivenClass(KotlinType kotlinType, FqNameUnsafe fqNameUnsafe) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(105);
        }
        if (fqNameUnsafe == null) {
            KotlinBuiltIns.$$$reportNull$$$0(106);
        }
        return !kotlinType.isMarkedNullable() && KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, fqNameUnsafe);
    }

    public static boolean isSpecialClassWithNoSupertypes(ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(107);
        }
        return KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames$FqNames.any) || KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames$FqNames.nothing);
    }

    public static boolean isAny(ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(108);
        }
        return KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames$FqNames.any);
    }

    public static boolean isUByteArray(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(128);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames$FqNames.uByteArrayFqName.toUnsafe());
    }

    public static boolean isUShortArray(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(129);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames$FqNames.uShortArrayFqName.toUnsafe());
    }

    public static boolean isUIntArray(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(130);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames$FqNames.uIntArrayFqName.toUnsafe());
    }

    public static boolean isULongArray(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(131);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames$FqNames.uLongArrayFqName.toUnsafe());
    }

    public static boolean isUnsignedArrayType(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(132);
        }
        return KotlinBuiltIns.isUByteArray(kotlinType) || KotlinBuiltIns.isUShortArray(kotlinType) || KotlinBuiltIns.isUIntArray(kotlinType) || KotlinBuiltIns.isULongArray(kotlinType);
    }

    private static boolean isConstructedFromGivenClassAndNotNullable(KotlinType kotlinType, FqNameUnsafe fqNameUnsafe) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(134);
        }
        if (fqNameUnsafe == null) {
            KotlinBuiltIns.$$$reportNull$$$0(135);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, fqNameUnsafe) && !kotlinType.isMarkedNullable();
    }

    public static boolean isNothing(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(136);
        }
        return KotlinBuiltIns.isNothingOrNullableNothing(kotlinType) && !TypeUtils.isNullableType(kotlinType);
    }

    public static boolean isNothingOrNullableNothing(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(138);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, StandardNames$FqNames.nothing);
    }

    public static boolean isAnyOrNullableAny(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(139);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, StandardNames$FqNames.any);
    }

    public static boolean isNullableAny(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(140);
        }
        return KotlinBuiltIns.isAnyOrNullableAny(kotlinType) && kotlinType.isMarkedNullable();
    }

    public static boolean isDefaultBound(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(141);
        }
        return KotlinBuiltIns.isNullableAny(kotlinType);
    }

    public static boolean isUnit(KotlinType kotlinType) {
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(142);
        }
        return KotlinBuiltIns.isNotNullConstructedFromGivenClass(kotlinType, StandardNames$FqNames.unit);
    }

    public static boolean isString(KotlinType kotlinType) {
        return kotlinType != null && KotlinBuiltIns.isNotNullConstructedFromGivenClass(kotlinType, StandardNames$FqNames.string);
    }

    public static boolean isKClass(ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(157);
        }
        return KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames$FqNames.kClass);
    }

    public static boolean isDeprecated(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(160);
        }
        if (declarationDescriptor.getOriginal().getAnnotations().hasAnnotation(StandardNames$FqNames.deprecated)) {
            return true;
        }
        if (declarationDescriptor instanceof PropertyDescriptor) {
            declarationDescriptor = (PropertyDescriptor)declarationDescriptor;
            boolean bl = declarationDescriptor.isVar();
            PropertyGetterDescriptor propertyGetterDescriptor = declarationDescriptor.getGetter();
            declarationDescriptor = declarationDescriptor.getSetter();
            return propertyGetterDescriptor != null && KotlinBuiltIns.isDeprecated(propertyGetterDescriptor) && (!bl || declarationDescriptor != null && KotlinBuiltIns.isDeprecated(declarationDescriptor));
        }
        return false;
    }

    static /* synthetic */ SimpleType access$000(KotlinBuiltIns kotlinBuiltIns, String string) {
        return kotlinBuiltIns.getBuiltInTypeByClassName(string);
    }

    static /* synthetic */ ModuleDescriptorImpl access$200(KotlinBuiltIns kotlinBuiltIns) {
        return kotlinBuiltIns.builtInsModule;
    }

    static /* synthetic */ ModuleDescriptorImpl access$202(KotlinBuiltIns kotlinBuiltIns, ModuleDescriptorImpl moduleDescriptorImpl) {
        kotlinBuiltIns.builtInsModule = moduleDescriptorImpl;
        return moduleDescriptorImpl;
    }

    static {
        $assertionsDisabled = KotlinBuiltIns.class.desiredAssertionStatus() ^ true;
        BUILTINS_MODULE_NAME = Name.special("<built-ins module>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        int n2;
        Object object;
        switch (n) {
            default: {
                object = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 81: 
            case 84: 
            case 86: 
            case 87: {
                object = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 81: 
            case 84: 
            case 86: 
            case 87: {
                n2 = 2;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray[0] = "storageManager";
                break;
            }
            case 160: {
                objectArray[0] = "declarationDescriptor";
                break;
            }
            case 112: {
                objectArray[0] = "classDescriptor";
                break;
            }
            case 101: {
                objectArray[0] = "typeConstructor";
                break;
            }
            case 80: {
                objectArray[0] = "annotations";
                break;
            }
            case 79: 
            case 83: 
            case 85: {
                objectArray[0] = "argument";
                break;
            }
            case 78: 
            case 82: {
                objectArray[0] = "projectionType";
                break;
            }
            case 75: {
                objectArray[0] = "kotlinType";
                break;
            }
            case 73: {
                objectArray[0] = "primitiveType";
                break;
            }
            case 71: {
                objectArray[0] = "notNullArrayType";
                break;
            }
            case 67: {
                objectArray[0] = "arrayType";
                break;
            }
            case 46: {
                objectArray[0] = "classSimpleName";
                break;
            }
            case 16: 
            case 17: 
            case 53: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 105: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 161: {
                objectArray[0] = "type";
                break;
            }
            case 14: {
                objectArray[0] = "simpleName";
                break;
            }
            case 12: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 135: {
                objectArray[0] = "fqName";
                break;
            }
            case 9: 
            case 10: 
            case 76: 
            case 77: 
            case 89: 
            case 96: 
            case 103: 
            case 107: 
            case 108: 
            case 145: 
            case 146: 
            case 148: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                objectArray[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 81: 
            case 84: 
            case 86: 
            case 87: {
                objectArray[0] = "kotlin/reflect/jvm/internal/impl/builtins/KotlinBuiltIns";
                break;
            }
            case 2: {
                objectArray[0] = "computation";
                break;
            }
            case 1: 
            case 72: {
                objectArray[0] = "module";
            }
        }
        switch (n) {
            default: {
                objectArray[1] = "kotlin/reflect/jvm/internal/impl/builtins/KotlinBuiltIns";
                break;
            }
            case 87: {
                objectArray[1] = "getAnnotationType";
                break;
            }
            case 86: {
                objectArray[1] = "getEnumType";
                break;
            }
            case 81: 
            case 84: {
                objectArray[1] = "getArrayType";
                break;
            }
            case 74: {
                objectArray[1] = "getPrimitiveArrayKotlinType";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray[1] = "getArrayElementType";
                break;
            }
            case 66: {
                objectArray[1] = "getIterableType";
                break;
            }
            case 65: {
                objectArray[1] = "getStringType";
                break;
            }
            case 64: {
                objectArray[1] = "getUnitType";
                break;
            }
            case 63: {
                objectArray[1] = "getBooleanType";
                break;
            }
            case 62: {
                objectArray[1] = "getCharType";
                break;
            }
            case 61: {
                objectArray[1] = "getDoubleType";
                break;
            }
            case 60: {
                objectArray[1] = "getFloatType";
                break;
            }
            case 59: {
                objectArray[1] = "getLongType";
                break;
            }
            case 58: {
                objectArray[1] = "getIntType";
                break;
            }
            case 57: {
                objectArray[1] = "getShortType";
                break;
            }
            case 56: {
                objectArray[1] = "getByteType";
                break;
            }
            case 55: {
                objectArray[1] = "getNumberType";
                break;
            }
            case 54: {
                objectArray[1] = "getPrimitiveKotlinType";
                break;
            }
            case 52: {
                objectArray[1] = "getDefaultBound";
                break;
            }
            case 51: {
                objectArray[1] = "getNullableAnyType";
                break;
            }
            case 50: {
                objectArray[1] = "getAnyType";
                break;
            }
            case 49: {
                objectArray[1] = "getNullableNothingType";
                break;
            }
            case 48: {
                objectArray[1] = "getNothingType";
                break;
            }
            case 47: {
                objectArray[1] = "getBuiltInTypeByClassName";
                break;
            }
            case 45: {
                objectArray[1] = "getMutableListIterator";
                break;
            }
            case 44: {
                objectArray[1] = "getListIterator";
                break;
            }
            case 43: {
                objectArray[1] = "getMutableMapEntry";
                break;
            }
            case 42: {
                objectArray[1] = "getMapEntry";
                break;
            }
            case 41: {
                objectArray[1] = "getMutableMap";
                break;
            }
            case 40: {
                objectArray[1] = "getMap";
                break;
            }
            case 39: {
                objectArray[1] = "getMutableSet";
                break;
            }
            case 38: {
                objectArray[1] = "getSet";
                break;
            }
            case 37: {
                objectArray[1] = "getMutableList";
                break;
            }
            case 36: {
                objectArray[1] = "getList";
                break;
            }
            case 35: {
                objectArray[1] = "getMutableCollection";
                break;
            }
            case 34: {
                objectArray[1] = "getCollection";
                break;
            }
            case 33: {
                objectArray[1] = "getMutableIterator";
                break;
            }
            case 32: {
                objectArray[1] = "getMutableIterable";
                break;
            }
            case 31: {
                objectArray[1] = "getIterable";
                break;
            }
            case 30: {
                objectArray[1] = "getIterator";
                break;
            }
            case 29: {
                objectArray[1] = "getKMutableProperty2";
                break;
            }
            case 28: {
                objectArray[1] = "getKMutableProperty1";
                break;
            }
            case 27: {
                objectArray[1] = "getKMutableProperty0";
                break;
            }
            case 26: {
                objectArray[1] = "getKProperty2";
                break;
            }
            case 25: {
                objectArray[1] = "getKProperty1";
                break;
            }
            case 24: {
                objectArray[1] = "getKProperty0";
                break;
            }
            case 23: {
                objectArray[1] = "getKProperty";
                break;
            }
            case 22: {
                objectArray[1] = "getKCallable";
                break;
            }
            case 21: {
                objectArray[1] = "getKClass";
                break;
            }
            case 20: {
                objectArray[1] = "getKSuspendFunction";
                break;
            }
            case 19: {
                objectArray[1] = "getKFunction";
                break;
            }
            case 18: {
                objectArray[1] = "getSuspendFunction";
                break;
            }
            case 15: {
                objectArray[1] = "getBuiltInClassByName";
                break;
            }
            case 13: {
                objectArray[1] = "getBuiltInClassByFqName";
                break;
            }
            case 11: {
                objectArray[1] = "getBuiltInsPackageScope";
                break;
            }
            case 8: {
                objectArray[1] = "getBuiltInPackagesImportedByDefault";
                break;
            }
            case 7: {
                objectArray[1] = "getBuiltInsModule";
                break;
            }
            case 6: {
                objectArray[1] = "getStorageManager";
                break;
            }
            case 5: {
                objectArray[1] = "getClassDescriptorFactories";
                break;
            }
            case 4: {
                objectArray[1] = "getPlatformDependentDeclarationFilter";
                break;
            }
            case 3: {
                objectArray[1] = "getAdditionalClassPartsProvider";
            }
        }
        switch (n) {
            default: {
                objectArray[2] = "<init>";
                break;
            }
            case 161: {
                objectArray[2] = "isNotNullOrNullableFunctionSupertype";
                break;
            }
            case 160: {
                objectArray[2] = "isDeprecated";
                break;
            }
            case 159: {
                objectArray[2] = "isCloneable";
                break;
            }
            case 158: {
                objectArray[2] = "isNonPrimitiveArray";
                break;
            }
            case 157: {
                objectArray[2] = "isKClass";
                break;
            }
            case 156: {
                objectArray[2] = "isThrowable";
                break;
            }
            case 155: {
                objectArray[2] = "isThrowableOrNullableThrowable";
                break;
            }
            case 154: {
                objectArray[2] = "isIterableOrNullableIterable";
                break;
            }
            case 153: {
                objectArray[2] = "isMapOrNullableMap";
                break;
            }
            case 152: {
                objectArray[2] = "isSetOrNullableSet";
                break;
            }
            case 151: {
                objectArray[2] = "isListOrNullableList";
                break;
            }
            case 150: {
                objectArray[2] = "isCollectionOrNullableCollection";
                break;
            }
            case 148: 
            case 149: {
                objectArray[2] = "isComparable";
                break;
            }
            case 146: 
            case 147: {
                objectArray[2] = "isEnum";
                break;
            }
            case 145: {
                objectArray[2] = "isMemberOfAny";
                break;
            }
            case 144: {
                objectArray[2] = "isBooleanOrSubtype";
                break;
            }
            case 143: {
                objectArray[2] = "isUnitOrNullableUnit";
                break;
            }
            case 142: {
                objectArray[2] = "isUnit";
                break;
            }
            case 141: {
                objectArray[2] = "isDefaultBound";
                break;
            }
            case 140: {
                objectArray[2] = "isNullableAny";
                break;
            }
            case 139: {
                objectArray[2] = "isAnyOrNullableAny";
                break;
            }
            case 138: {
                objectArray[2] = "isNothingOrNullableNothing";
                break;
            }
            case 137: {
                objectArray[2] = "isNullableNothing";
                break;
            }
            case 136: {
                objectArray[2] = "isNothing";
                break;
            }
            case 134: 
            case 135: {
                objectArray[2] = "isConstructedFromGivenClassAndNotNullable";
                break;
            }
            case 133: {
                objectArray[2] = "isDoubleOrNullableDouble";
                break;
            }
            case 132: {
                objectArray[2] = "isUnsignedArrayType";
                break;
            }
            case 131: {
                objectArray[2] = "isULongArray";
                break;
            }
            case 130: {
                objectArray[2] = "isUIntArray";
                break;
            }
            case 129: {
                objectArray[2] = "isUShortArray";
                break;
            }
            case 128: {
                objectArray[2] = "isUByteArray";
                break;
            }
            case 127: {
                objectArray[2] = "isULong";
                break;
            }
            case 126: {
                objectArray[2] = "isUInt";
                break;
            }
            case 125: {
                objectArray[2] = "isUShort";
                break;
            }
            case 124: {
                objectArray[2] = "isUByte";
                break;
            }
            case 123: {
                objectArray[2] = "isDouble";
                break;
            }
            case 122: {
                objectArray[2] = "isFloatOrNullableFloat";
                break;
            }
            case 121: {
                objectArray[2] = "isFloat";
                break;
            }
            case 120: {
                objectArray[2] = "isShort";
                break;
            }
            case 119: {
                objectArray[2] = "isLongOrNullableLong";
                break;
            }
            case 118: {
                objectArray[2] = "isLong";
                break;
            }
            case 117: {
                objectArray[2] = "isByte";
                break;
            }
            case 116: {
                objectArray[2] = "isInt";
                break;
            }
            case 115: {
                objectArray[2] = "isCharOrNullableChar";
                break;
            }
            case 114: {
                objectArray[2] = "isChar";
                break;
            }
            case 113: {
                objectArray[2] = "isNumber";
                break;
            }
            case 111: {
                objectArray[2] = "isBooleanOrNullableBoolean";
                break;
            }
            case 110: 
            case 112: {
                objectArray[2] = "isBoolean";
                break;
            }
            case 108: 
            case 109: {
                objectArray[2] = "isAny";
                break;
            }
            case 107: {
                objectArray[2] = "isSpecialClassWithNoSupertypes";
                break;
            }
            case 105: 
            case 106: {
                objectArray[2] = "isNotNullConstructedFromGivenClass";
                break;
            }
            case 103: 
            case 104: {
                objectArray[2] = "classFqNameEquals";
                break;
            }
            case 101: 
            case 102: {
                objectArray[2] = "isTypeConstructorForGivenClass";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray[2] = "isConstructedFromGivenClass";
                break;
            }
            case 96: {
                objectArray[2] = "isPrimitiveClass";
                break;
            }
            case 95: {
                objectArray[2] = "isPrimitiveTypeOrNullablePrimitiveType";
                break;
            }
            case 94: {
                objectArray[2] = "isPrimitiveType";
                break;
            }
            case 92: {
                objectArray[2] = "getPrimitiveArrayElementType";
                break;
            }
            case 91: {
                objectArray[2] = "isPrimitiveArray";
                break;
            }
            case 89: 
            case 90: {
                objectArray[2] = "isArrayOrPrimitiveArray";
                break;
            }
            case 88: {
                objectArray[2] = "isArray";
                break;
            }
            case 85: {
                objectArray[2] = "getEnumType";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: {
                objectArray[2] = "getArrayType";
                break;
            }
            case 77: {
                objectArray[2] = "getPrimitiveArrayType";
                break;
            }
            case 76: 
            case 93: {
                objectArray[2] = "getPrimitiveType";
                break;
            }
            case 75: {
                objectArray[2] = "getPrimitiveArrayKotlinTypeByPrimitiveKotlinType";
                break;
            }
            case 73: {
                objectArray[2] = "getPrimitiveArrayKotlinType";
                break;
            }
            case 71: 
            case 72: {
                objectArray[2] = "getElementTypeForUnsignedArray";
                break;
            }
            case 67: {
                objectArray[2] = "getArrayElementType";
                break;
            }
            case 53: {
                objectArray[2] = "getPrimitiveKotlinType";
                break;
            }
            case 46: {
                objectArray[2] = "getBuiltInTypeByClassName";
                break;
            }
            case 17: {
                objectArray[2] = "getPrimitiveArrayClassDescriptor";
                break;
            }
            case 16: {
                objectArray[2] = "getPrimitiveClassDescriptor";
                break;
            }
            case 14: {
                objectArray[2] = "getBuiltInClassByName";
                break;
            }
            case 12: {
                objectArray[2] = "getBuiltInClassByFqName";
                break;
            }
            case 10: {
                objectArray[2] = "isUnderKotlinPackage";
                break;
            }
            case 9: {
                objectArray[2] = "isBuiltIn";
                break;
            }
            case 2: {
                objectArray[2] = "setPostponedBuiltinsModuleComputation";
                break;
            }
            case 1: {
                objectArray[2] = "setBuiltInsModule";
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
        }
        String string = String.format((String)object, objectArray);
        switch (n) {
            default: {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException(string);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 81: 
            case 84: 
            case 86: 
            case 87: {
                IllegalStateException illegalStateException;
                object = illegalStateException;
                illegalStateException = new IllegalStateException(string);
            }
        }
        throw object;
    }

    protected void createBuiltInsModule(boolean bl) {
        KotlinBuiltIns kotlinBuiltIns = object2;
        Object object = BUILTINS_MODULE_NAME;
        ((KotlinBuiltIns)object2).builtInsModule = new ModuleDescriptorImpl((Name)object, ((KotlinBuiltIns)object2).storageManager, (KotlinBuiltIns)object2, null);
        KotlinBuiltIns kotlinBuiltIns2 = object2;
        Object object2 = kotlinBuiltIns2.storageManager;
        object = kotlinBuiltIns2.builtInsModule;
        Iterable iterable = kotlinBuiltIns2.getClassDescriptorFactories();
        PlatformDependentDeclarationFilter platformDependentDeclarationFilter = kotlinBuiltIns2.getPlatformDependentDeclarationFilter();
        AdditionalClassPartsProvider additionalClassPartsProvider = kotlinBuiltIns2.getAdditionalClassPartsProvider();
        ((KotlinBuiltIns)object2).builtInsModule.initialize(BuiltInsLoader.Companion.getInstance().createPackageFragmentProvider((StorageManager)object2, (ModuleDescriptor)object, iterable, platformDependentDeclarationFilter, additionalClassPartsProvider, bl));
        object2 = kotlinBuiltIns.builtInsModule;
        ((ModuleDescriptorImpl)object2).setDependencies(new ModuleDescriptorImpl[]{object2});
    }

    public void setBuiltInsModule(ModuleDescriptorImpl moduleDescriptorImpl) {
        if (moduleDescriptorImpl == null) {
            KotlinBuiltIns.$$$reportNull$$$0(1);
        }
        this.storageManager.compute(new KotlinBuiltIns$4(this, moduleDescriptorImpl));
    }

    protected AdditionalClassPartsProvider getAdditionalClassPartsProvider() {
        AdditionalClassPartsProvider$None additionalClassPartsProvider$None = AdditionalClassPartsProvider$None.INSTANCE;
        if (additionalClassPartsProvider$None == null) {
            KotlinBuiltIns.$$$reportNull$$$0(3);
        }
        return additionalClassPartsProvider$None;
    }

    protected PlatformDependentDeclarationFilter getPlatformDependentDeclarationFilter() {
        PlatformDependentDeclarationFilter$NoPlatformDependent platformDependentDeclarationFilter$NoPlatformDependent = PlatformDependentDeclarationFilter$NoPlatformDependent.INSTANCE;
        if (platformDependentDeclarationFilter$NoPlatformDependent == null) {
            KotlinBuiltIns.$$$reportNull$$$0(4);
        }
        return platformDependentDeclarationFilter$NoPlatformDependent;
    }

    protected Iterable getClassDescriptorFactories() {
        KotlinBuiltIns kotlinBuiltIns = list;
        List<BuiltInFictitiousFunctionClassFactory> list = kotlinBuiltIns.storageManager;
        if ((list = Collections.singletonList(new BuiltInFictitiousFunctionClassFactory((StorageManager)((Object)list), kotlinBuiltIns.getBuiltInsModule()))) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(5);
        }
        return list;
    }

    protected StorageManager getStorageManager() {
        StorageManager storageManager = ((KotlinBuiltIns)((Object)storageManager)).storageManager;
        if (storageManager == null) {
            KotlinBuiltIns.$$$reportNull$$$0(6);
        }
        return storageManager;
    }

    public ModuleDescriptorImpl getBuiltInsModule() {
        if (!$assertionsDisabled && ((KotlinBuiltIns)this).builtInsModule == null && ((KotlinBuiltIns)this).postponedBuiltInsModule == null) {
            throw new AssertionError((Object)"Uninitialized built-ins module");
        }
        if (((KotlinBuiltIns)this).builtInsModule == null) {
            ((KotlinBuiltIns)this).builtInsModule = (ModuleDescriptorImpl)((KotlinBuiltIns)this).postponedBuiltInsModule.invoke();
        }
        if ((this = ((KotlinBuiltIns)this).builtInsModule) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(7);
        }
        return this;
    }

    public MemberScope getBuiltInsPackageScope() {
        if ((this = ((KotlinBuiltIns)this).getBuiltInsModule().getPackage(StandardNames.BUILT_INS_PACKAGE_FQ_NAME).getMemberScope()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(11);
        }
        return this;
    }

    public ClassDescriptor getBuiltInClassByFqName(FqName fqName2) {
        if (fqName2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(12);
        }
        ClassDescriptor classDescriptor = DescriptorUtilKt.resolveClassByFqName(((KotlinBuiltIns)((Object)classDescriptor)).getBuiltInsModule(), fqName2, NoLookupLocation.FROM_BUILTINS);
        if (!$assertionsDisabled && classDescriptor == null) {
            throw new AssertionError((Object)("Can't find built-in class " + fqName2));
        }
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(13);
        }
        return classDescriptor;
    }

    public ClassDescriptor getAny() {
        return this.getBuiltInClassByName("Any");
    }

    public ClassDescriptor getNothing() {
        return this.getBuiltInClassByName("Nothing");
    }

    public ClassDescriptor getArray() {
        return this.getBuiltInClassByName("Array");
    }

    public ClassDescriptor getNumber() {
        return this.getBuiltInClassByName("Number");
    }

    public ClassDescriptor getUnit() {
        return this.getBuiltInClassByName("Unit");
    }

    public ClassDescriptor getFunction(int n) {
        return this.getBuiltInClassByName(StandardNames.getFunctionName(n));
    }

    public ClassDescriptor getSuspendFunction(int n) {
        if ((this = ((KotlinBuiltIns)this).getBuiltInClassByFqName(StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier(StandardNames.getSuspendFunctionName(n))))) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(18);
        }
        return this;
    }

    public ClassDescriptor getString() {
        return this.getBuiltInClassByName("String");
    }

    public ClassDescriptor getComparable() {
        return this.getBuiltInClassByName("Comparable");
    }

    public ClassDescriptor getKClass() {
        if ((this = ((KotlinBuiltIns)this).getBuiltInClassByFqName(StandardNames$FqNames.kClass.toSafe())) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(21);
        }
        return this;
    }

    public ClassDescriptor getCollection() {
        if ((this = ((KotlinBuiltIns)this).getBuiltInClassByFqName(StandardNames$FqNames.collection)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(34);
        }
        return this;
    }

    public SimpleType getNothingType() {
        if ((this = ((KotlinBuiltIns)this).getNothing().getDefaultType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(48);
        }
        return this;
    }

    public SimpleType getNullableNothingType() {
        if ((this = ((KotlinBuiltIns)this).getNothingType().makeNullableAsSpecified(true)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(49);
        }
        return this;
    }

    public SimpleType getAnyType() {
        if ((this = ((KotlinBuiltIns)this).getAny().getDefaultType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(50);
        }
        return this;
    }

    public SimpleType getNullableAnyType() {
        if ((this = ((KotlinBuiltIns)this).getAnyType().makeNullableAsSpecified(true)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(51);
        }
        return this;
    }

    public SimpleType getDefaultBound() {
        if ((this = ((KotlinBuiltIns)this).getNullableAnyType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(52);
        }
        return this;
    }

    public SimpleType getPrimitiveKotlinType(PrimitiveType primitiveType) {
        if (primitiveType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(53);
        }
        if ((this = ((KotlinBuiltIns)this).getPrimitiveClassDescriptor(primitiveType).getDefaultType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(54);
        }
        return this;
    }

    public SimpleType getNumberType() {
        if ((this = ((KotlinBuiltIns)this).getNumber().getDefaultType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(55);
        }
        return this;
    }

    public SimpleType getByteType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.BYTE)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(56);
        }
        return this;
    }

    public SimpleType getShortType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.SHORT)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(57);
        }
        return this;
    }

    public SimpleType getIntType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.INT)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(58);
        }
        return this;
    }

    public SimpleType getLongType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.LONG)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(59);
        }
        return this;
    }

    public SimpleType getFloatType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.FLOAT)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(60);
        }
        return this;
    }

    public SimpleType getDoubleType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.DOUBLE)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(61);
        }
        return this;
    }

    public SimpleType getCharType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.CHAR)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(62);
        }
        return this;
    }

    public SimpleType getBooleanType() {
        if ((this = ((KotlinBuiltIns)this).getPrimitiveKotlinType(PrimitiveType.BOOLEAN)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(63);
        }
        return this;
    }

    public SimpleType getUnitType() {
        if ((this = ((KotlinBuiltIns)this).getUnit().getDefaultType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(64);
        }
        return this;
    }

    public SimpleType getStringType() {
        if ((this = ((KotlinBuiltIns)this).getString().getDefaultType()) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(65);
        }
        return this;
    }

    public KotlinType getArrayElementType(KotlinType kotlinType) {
        Object object;
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(67);
        }
        if (KotlinBuiltIns.isArray(kotlinType)) {
            if (kotlinType.getArguments().size() == 1) {
                object = ((TypeProjection)kotlinType.getArguments().get(0)).getType();
                if (object == null) {
                    KotlinBuiltIns.$$$reportNull$$$0(68);
                }
                return object;
            }
            throw new IllegalStateException();
        }
        object = TypeUtils.makeNotNullable(kotlinType);
        Annotated annotated = (KotlinType)((KotlinBuiltIns$Primitives)((KotlinBuiltIns)object).primitives.invoke()).kotlinArrayTypeToPrimitiveKotlinType.get(object);
        if (annotated != null) {
            return annotated;
        }
        annotated = DescriptorUtils.getContainingModuleOrNull((KotlinType)object);
        if (annotated != null && (object = KotlinBuiltIns.getElementTypeForUnsignedArray((KotlinType)object, (ModuleDescriptor)annotated)) != null) {
            return object;
        }
        throw new IllegalStateException("not array: " + kotlinType);
    }

    public SimpleType getPrimitiveArrayKotlinType(PrimitiveType primitiveType) {
        if (primitiveType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(73);
        }
        if ((this = (SimpleType)((KotlinBuiltIns$Primitives)((KotlinBuiltIns)this).primitives.invoke()).primitiveTypeToArrayKotlinType.get((Object)primitiveType)) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(74);
        }
        return this;
    }

    public SimpleType getArrayType(Variance object, KotlinType kotlinType, Annotations annotations2) {
        if (object == null) {
            KotlinBuiltIns.$$$reportNull$$$0(78);
        }
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(79);
        }
        if (annotations2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(80);
        }
        object = Collections.singletonList(new TypeProjectionImpl((Variance)((Object)object), kotlinType));
        SimpleType simpleType2 = KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(annotations2), ((KotlinBuiltIns)((Object)simpleType2)).getArray(), (List)object);
        if (simpleType2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(81);
        }
        return simpleType2;
    }

    public SimpleType getArrayType(Variance variance, KotlinType kotlinType) {
        if (variance == null) {
            KotlinBuiltIns.$$$reportNull$$$0(82);
        }
        if (kotlinType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(83);
        }
        if ((this = ((KotlinBuiltIns)this).getArrayType(variance, kotlinType, Annotations.Companion.getEMPTY())) == null) {
            KotlinBuiltIns.$$$reportNull$$$0(84);
        }
        return this;
    }
}

