/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderOptimized;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class CompositePackageFragmentProvider
implements PackageFragmentProviderOptimized {
    private final List providers;
    private final String debugName;

    public CompositePackageFragmentProvider(List object, String string) {
        Intrinsics.checkNotNullParameter(object, "providers");
        Intrinsics.checkNotNullParameter(string, "debugName");
        this.providers = object;
        this.debugName = string;
        boolean bl = object.size() == CollectionsKt.toSet((Iterable)object).size();
        if (_Assertions.ENABLED && !bl) {
            object = "providers.size is " + object.size() + " while only " + CollectionsKt.toSet((Iterable)object).size() + " unique providers";
            throw new AssertionError(object);
        }
    }

    @Override
    public List getPackageFragments(FqName fqName2) {
        ArrayList arrayList;
        CompositePackageFragmentProvider compositePackageFragmentProvider = arrayList2;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator iterator2 = compositePackageFragmentProvider.providers.iterator();
        while (iterator2.hasNext()) {
            PackageFragmentProviderKt.collectPackageFragmentsOptimizedIfPossible((PackageFragmentProvider)iterator2.next(), fqName2, arrayList2);
        }
        return CollectionsKt.toList(arrayList2);
    }

    @Override
    public void collectPackageFragments(FqName fqName2, Collection collection) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(collection, "packageFragments");
        Iterator iterator2 = ((CompositePackageFragmentProvider)((Object)iterator2)).providers.iterator();
        while (iterator2.hasNext()) {
            PackageFragmentProviderKt.collectPackageFragmentsOptimizedIfPossible((PackageFragmentProvider)iterator2.next(), fqName2, collection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty(FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Iterator iterator2 = ((CompositePackageFragmentProvider)((Object)iterator2)).providers;
        if (iterator2 instanceof Collection && iterator2.isEmpty()) {
            return true;
        }
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (PackageFragmentProviderKt.isEmpty((PackageFragmentProvider)iterator2.next(), fqName2));
        return false;
    }

    @Override
    public Collection getSubPackagesOf(FqName fqName2, Function1 function1) {
        HashSet hashSet;
        CompositePackageFragmentProvider compositePackageFragmentProvider = hashSet2;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(function1, "nameFilter");
        HashSet hashSet2 = hashSet;
        hashSet = new HashSet();
        Iterator iterator2 = compositePackageFragmentProvider.providers.iterator();
        while (iterator2.hasNext()) {
            hashSet2.addAll(((PackageFragmentProvider)iterator2.next()).getSubPackagesOf(fqName2, function1));
        }
        return hashSet2;
    }

    public String toString() {
        return this.debugName;
    }
}

