/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents$jvmDescriptor$1;

public final class SignatureBuildingComponents {
    public static final SignatureBuildingComponents INSTANCE = new SignatureBuildingComponents();

    private SignatureBuildingComponents() {
    }

    private final String escapeClassName(String string) {
        if (string.length() > 1) {
            string = 'L' + string + ';';
        }
        return string;
    }

    public static final /* synthetic */ String access$escapeClassName(SignatureBuildingComponents signatureBuildingComponents, String string) {
        return signatureBuildingComponents.escapeClassName(string);
    }

    public final String javaLang(String string) {
        Intrinsics.checkNotNullParameter(string, "name");
        return "java/lang/" + string;
    }

    public final String javaUtil(String string) {
        Intrinsics.checkNotNullParameter(string, "name");
        return "java/util/" + string;
    }

    public final String javaFunction(String string) {
        Intrinsics.checkNotNullParameter(string, "name");
        return "java/util/function/" + string;
    }

    public final String[] constructors(String ... stringArray) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(stringArray, "signatures");
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(stringArray.length);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add("<init>(" + stringArray[i] + ")V");
        }
        String[] stringArray2 = arrayList2.toArray(new String[0]);
        Intrinsics.checkNotNull(stringArray2, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return stringArray2;
    }

    public final Set inJavaLang(String string, String ... stringArray) {
        SignatureBuildingComponents signatureBuildingComponents = string2;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(stringArray, "signatures");
        String string2 = ((SignatureBuildingComponents)((Object)string2)).javaLang(string);
        return signatureBuildingComponents.inClass(string2, Arrays.copyOf(stringArray, stringArray.length));
    }

    public final Set inJavaUtil(String string, String ... stringArray) {
        SignatureBuildingComponents signatureBuildingComponents = string2;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(stringArray, "signatures");
        String string2 = ((SignatureBuildingComponents)((Object)string2)).javaUtil(string);
        return signatureBuildingComponents.inClass(string2, Arrays.copyOf(stringArray, stringArray.length));
    }

    public final Set inClass(String string, String ... stringArray) {
        LinkedHashSet linkedHashSet;
        Intrinsics.checkNotNullParameter(string, "internalName");
        Intrinsics.checkNotNullParameter(stringArray, "signatures");
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            linkedHashSet2.add(string + '.' + stringArray[i]);
        }
        return linkedHashSet2;
    }

    public final String signature(String string, String string2) {
        Intrinsics.checkNotNullParameter(string, "internalName");
        Intrinsics.checkNotNullParameter(string2, "jvmDescriptor");
        return string + '.' + string2;
    }

    public final String jvmDescriptor(String object, List list, String string) {
        Intrinsics.checkNotNullParameter(object, "name");
        Intrinsics.checkNotNullParameter(list, "parameters");
        Intrinsics.checkNotNullParameter(string, "ret");
        StringBuilder stringBuilder = new StringBuilder().append((String)object).append('(');
        object = SignatureBuildingComponents$jvmDescriptor$1.INSTANCE;
        return stringBuilder.append(CollectionsKt.joinToString$default(list, "", null, null, 0, null, (Function1)object, 30, null)).append(')').append(this.escapeClassName(string)).toString();
    }
}

