/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.CallableId$Companion;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.text.StringsKt;

public final class CallableId {
    private static final CallableId$Companion Companion = new CallableId$Companion(null);
    private static final Name LOCAL_NAME = SpecialNames.LOCAL;
    private static final FqName PACKAGE_FQ_NAME_FOR_LOCAL;
    private final FqName packageName;
    private final FqName className;
    private final Name callableName;
    private final FqName pathToLocal;

    public CallableId(FqName fqName2, FqName fqName3, Name name, FqName fqName4) {
        Intrinsics.checkNotNullParameter(fqName2, "packageName");
        Intrinsics.checkNotNullParameter(name, "callableName");
        this.packageName = fqName2;
        this.className = fqName3;
        this.callableName = name;
        this.pathToLocal = fqName4;
    }

    public /* synthetic */ CallableId(FqName fqName2, FqName fqName3, Name name, FqName fqName4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            fqName4 = null;
        }
        this(fqName2, fqName3, name, fqName4);
    }

    public CallableId(FqName fqName2, Name name) {
        Intrinsics.checkNotNullParameter(fqName2, "packageName");
        Intrinsics.checkNotNullParameter(name, "callableName");
        this(fqName2, null, name, null, 8, null);
    }

    static {
        FqName fqName2 = FqName.topLevel(LOCAL_NAME);
        Intrinsics.checkNotNullExpressionValue(fqName2, "topLevel(LOCAL_NAME)");
        PACKAGE_FQ_NAME_FOR_LOCAL = fqName2;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        String string = this.packageName.asString();
        Intrinsics.checkNotNullExpressionValue(string, "packageName.asString()");
        stringBuilder.append(StringsKt.replace$default(string, '.', '/', false, 4, null));
        stringBuilder.append("/");
        FqName fqName2 = this.className;
        if (fqName2 != null) {
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append(fqName2);
            stringBuilder3.append(".");
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append(this.callableName);
        String string2 = stringBuilder4.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public int hashCode() {
        CallableId callableId = this;
        int n = callableId.packageName.hashCode() * 31;
        FqName fqName2 = callableId.className;
        int n2 = fqName2 == null ? 0 : fqName2.hashCode();
        int n3 = ((n + n2) * 31 + this.callableName.hashCode()) * 31;
        FqName fqName3 = this.pathToLocal;
        int n4 = fqName3 == null ? 0 : fqName3.hashCode();
        return n3 + n4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CallableId)) {
            return false;
        }
        object = (CallableId)object;
        if (!Intrinsics.areEqual(this.packageName, ((CallableId)object).packageName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.className, ((CallableId)object).className)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.callableName, ((CallableId)object).callableName)) {
            return false;
        }
        return Intrinsics.areEqual(this.pathToLocal, ((CallableId)object).pathToLocal);
    }
}

