/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;

public final class ClassLiteralValue {
    private final ClassId classId;
    private final int arrayNestedness;

    public ClassLiteralValue(ClassId classId, int n) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        this.classId = classId;
        this.arrayNestedness = n;
    }

    public final ClassId getClassId() {
        return this.classId;
    }

    public final int getArrayNestedness() {
        return this.arrayNestedness;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = this.arrayNestedness;
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append("kotlin/Array<");
        }
        stringBuilder2.append(this.classId);
        int n2 = this.arrayNestedness;
        for (n = 0; n < n2; ++n) {
            stringBuilder2.append(">");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final ClassId component1() {
        return this.classId;
    }

    public final int component2() {
        return this.arrayNestedness;
    }

    public int hashCode() {
        return this.classId.hashCode() * 31 + this.arrayNestedness;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassLiteralValue)) {
            return false;
        }
        object = (ClassLiteralValue)object;
        if (!Intrinsics.areEqual(this.classId, ((ClassLiteralValue)object).classId)) {
            return false;
        }
        return this.arrayNestedness == ((ClassLiteralValue)object).arrayNestedness;
    }
}

