/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;

public final class AbstractStrictEqualityTypeChecker {
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean strictEqualTypesInternal(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        if (kotlinTypeMarker == kotlinTypeMarker2) {
            return true;
        }
        SimpleTypeMarker simpleTypeMarker = typeSystemContext.asSimpleType(kotlinTypeMarker);
        SimpleTypeMarker simpleTypeMarker2 = typeSystemContext.asSimpleType(kotlinTypeMarker2);
        if (simpleTypeMarker != null && simpleTypeMarker2 != null) {
            return ((AbstractStrictEqualityTypeChecker)this).strictEqualSimpleTypes(typeSystemContext, simpleTypeMarker, simpleTypeMarker2);
        }
        kotlinTypeMarker = typeSystemContext.asFlexibleType(kotlinTypeMarker);
        kotlinTypeMarker2 = typeSystemContext.asFlexibleType(kotlinTypeMarker2);
        if (kotlinTypeMarker == null) return false;
        if (kotlinTypeMarker2 == null) return false;
        TypeSystemContext typeSystemContext2 = typeSystemContext;
        simpleTypeMarker = typeSystemContext.lowerBound((FlexibleTypeMarker)kotlinTypeMarker);
        if (!((AbstractStrictEqualityTypeChecker)this).strictEqualSimpleTypes(typeSystemContext2, simpleTypeMarker, typeSystemContext2.lowerBound((FlexibleTypeMarker)kotlinTypeMarker2))) return false;
        TypeSystemContext typeSystemContext3 = typeSystemContext;
        if (!((AbstractStrictEqualityTypeChecker)this).strictEqualSimpleTypes(typeSystemContext3, (SimpleTypeMarker)(this = typeSystemContext.upperBound((FlexibleTypeMarker)kotlinTypeMarker)), typeSystemContext3.upperBound((FlexibleTypeMarker)kotlinTypeMarker2))) return false;
        return true;
    }

    private final boolean strictEqualSimpleTypes(TypeSystemContext typeSystemContext, SimpleTypeMarker simpleTypeMarker, SimpleTypeMarker simpleTypeMarker2) {
        int n;
        int n2;
        if (typeSystemContext.argumentsCount(simpleTypeMarker) == typeSystemContext.argumentsCount(simpleTypeMarker2) && typeSystemContext.isMarkedNullable(simpleTypeMarker) == typeSystemContext.isMarkedNullable(simpleTypeMarker2) && (n2 = typeSystemContext.asDefinitelyNotNullType(simpleTypeMarker) == null) == (n = typeSystemContext.asDefinitelyNotNullType(simpleTypeMarker2) == null ? 1 : 0)) {
            TypeSystemContext typeSystemContext2 = typeSystemContext;
            TypeConstructorMarker typeConstructorMarker = typeSystemContext.typeConstructor(simpleTypeMarker);
            if (typeSystemContext2.areEqualTypeConstructors(typeConstructorMarker, typeSystemContext2.typeConstructor(simpleTypeMarker2))) {
                if (typeSystemContext.identicalArguments(simpleTypeMarker, simpleTypeMarker2)) {
                    return true;
                }
                n = typeSystemContext.argumentsCount(simpleTypeMarker);
                for (int i = 0; i < n; ++i) {
                    TypeSystemContext typeSystemContext3 = typeSystemContext;
                    Object object = typeSystemContext.getArgument(simpleTypeMarker, i);
                    TypeArgumentMarker typeArgumentMarker = typeSystemContext3.getArgument(simpleTypeMarker2, i);
                    if (typeSystemContext3.isStarProjection((TypeArgumentMarker)object) != typeSystemContext.isStarProjection(typeArgumentMarker)) {
                        return false;
                    }
                    if (typeSystemContext.isStarProjection((TypeArgumentMarker)object)) continue;
                    if (typeSystemContext.getVariance((TypeArgumentMarker)object) != typeSystemContext.getVariance(typeArgumentMarker)) {
                        return false;
                    }
                    TypeSystemContext typeSystemContext4 = typeSystemContext;
                    if (this.strictEqualTypesInternal(typeSystemContext4, (KotlinTypeMarker)(object = typeSystemContext.getType((TypeArgumentMarker)object)), typeSystemContext4.getType(typeArgumentMarker))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final boolean strictEqualTypes(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        Intrinsics.checkNotNullParameter(typeSystemContext, "context");
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "a");
        Intrinsics.checkNotNullParameter(kotlinTypeMarker2, "b");
        return this.strictEqualTypesInternal(typeSystemContext, kotlinTypeMarker, kotlinTypeMarker2);
    }
}

