/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope$Empty;
import kotlin.reflect.jvm.internal.impl.types.AnnotationsTypeAttributeKt;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpander$Companion;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansion;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansionReportStrategy;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansionReportStrategy$DO_NOTHING;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class TypeAliasExpander {
    public static final TypeAliasExpander$Companion Companion = new TypeAliasExpander$Companion(null);
    private static final TypeAliasExpander NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy$DO_NOTHING.INSTANCE, false);
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private final boolean shouldCheckBounds;

    public TypeAliasExpander(TypeAliasExpansionReportStrategy typeAliasExpansionReportStrategy, boolean bl) {
        Intrinsics.checkNotNullParameter(typeAliasExpansionReportStrategy, "reportStrategy");
        this.reportStrategy = typeAliasExpansionReportStrategy;
        this.shouldCheckBounds = bl;
    }

    private final SimpleType expandRecursively(TypeAliasExpansion typeAliasExpansion, TypeAttributes typeAttributes, boolean bl, int n, boolean bl2) {
        Variance variance = Variance.INVARIANT;
        Object object = ((TypeAliasExpander)((Object)string)).expandTypeProjection(new TypeProjectionImpl(variance, typeAliasExpansion.getDescriptor().getUnderlyingType()), typeAliasExpansion, null, n);
        KotlinType kotlinType = object.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "expandedProjection.type");
        SimpleType simpleType2 = TypeSubstitutionKt.asSimpleType(kotlinType);
        if (KotlinTypeKt.isError(simpleType2)) {
            return simpleType2;
        }
        boolean bl3 = object.getProjectionKind() == variance;
        if (_Assertions.ENABLED && !bl3) {
            String string = "Type alias expansion: result for " + typeAliasExpansion.getDescriptor() + " is " + (Object)((Object)object.getProjectionKind()) + ", should be invariant";
            throw new AssertionError((Object)string);
        }
        object = simpleType2.getAnnotations();
        ((TypeAliasExpander)((Object)string)).checkRepeatedAnnotations((Annotations)object, AnnotationsTypeAttributeKt.getAnnotations(typeAttributes));
        object = TypeUtils.makeNullableIfNeeded(((TypeAliasExpander)((Object)string)).combineAttributes(simpleType2, typeAttributes), bl);
        Intrinsics.checkNotNullExpressionValue(object, "expandedType.combineAttr\u2026fNeeded(it, isNullable) }");
        if (bl2) {
            object = SpecialTypesKt.withAbbreviation((SimpleType)object, super.createAbbreviation(typeAliasExpansion, typeAttributes, bl));
        }
        return object;
    }

    private final SimpleType createAbbreviation(TypeAliasExpansion object, TypeAttributes typeAttributes, boolean bl) {
        TypeAliasExpansion typeAliasExpansion = object;
        Object object2 = typeAliasExpansion.getDescriptor().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(object2, "descriptor.typeConstructor");
        object = typeAliasExpansion.getArguments();
        Object object3 = object2;
        object2 = MemberScope$Empty.INSTANCE;
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(typeAttributes, (TypeConstructor)object3, (List)object, bl, (MemberScope)object2);
    }

    private final TypeProjection expandTypeProjection(TypeProjection object, TypeAliasExpansion typeAliasExpansion, TypeParameterDescriptor typeParameterDescriptor, int n) {
        Variance variance;
        TypeAliasExpander$Companion.access$assertRecursionDepth(Companion, n, typeAliasExpansion.getDescriptor());
        if (object.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkNotNull(typeParameterDescriptor2);
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkNotNullExpressionValue(typeProjection, "makeStarProjection(typeParameterDescriptor!!)");
            return typeProjection;
        }
        KotlinType kotlinType = object.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "underlyingProjection.type");
        Object object2 = typeAliasExpansion.getReplacement(kotlinType.getConstructor());
        if (object2 == null) {
            return ((TypeAliasExpander)object5).expandNonArgumentTypeProjection((TypeProjection)object, typeAliasExpansion, n);
        }
        if (object2.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            Intrinsics.checkNotNull(typeParameterDescriptor3);
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor3);
            Intrinsics.checkNotNullExpressionValue(typeProjection, "makeStarProjection(typeParameterDescriptor!!)");
            return typeProjection;
        }
        TypeProjection typeProjection = object;
        TypeProjection typeProjection2 = object2;
        object = typeProjection2.getType().unwrap();
        Object object3 = typeProjection2.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue(object3, "argument.projectionKind");
        object2 = typeProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue(object2, "underlyingProjection.projectionKind");
        if (object2 != object3 && object2 != (variance = Variance.INVARIANT)) {
            if (object3 == variance) {
                object3 = object2;
            } else {
                ((TypeAliasExpander)object5).reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, (KotlinType)object);
            }
        }
        if (typeParameterDescriptor == null || (object2 = typeParameterDescriptor.getVariance()) == null) {
            object2 = Variance.INVARIANT;
        }
        Object object4 = object2;
        Intrinsics.checkNotNullExpressionValue(object4, "typeParameterDescriptor?\u2026nce ?: Variance.INVARIANT");
        if (object4 != object3 && object2 != (object2 = Variance.INVARIANT)) {
            if (object3 == object2) {
                object3 = object2;
            } else {
                ((TypeAliasExpander)object5).reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, (KotlinType)object);
            }
        }
        TypeAliasExpander typeAliasExpander = object5;
        TypeAliasExpander typeAliasExpander2 = object5;
        Object object5 = kotlinType.getAnnotations();
        typeAliasExpander2.checkRepeatedAnnotations((Annotations)object5, ((KotlinType)object).getAnnotations());
        object5 = typeAliasExpander.combineNullabilityAndAnnotations(TypeSubstitutionKt.asSimpleType((KotlinType)object), kotlinType);
        return new TypeProjectionImpl((Variance)((Object)object3), (KotlinType)object5);
    }

    private final SimpleType combineAttributes(SimpleType simpleType2, TypeAttributes typeAttributes) {
        if (!KotlinTypeKt.isError(simpleType2)) {
            simpleType2 = TypeSubstitutionKt.replace$default(simpleType2, null, this.createdCombinedAttributes(simpleType2, typeAttributes), 1, null);
        }
        return simpleType2;
    }

    private final TypeAttributes createdCombinedAttributes(KotlinType kotlinType, TypeAttributes typeAttributes) {
        if (KotlinTypeKt.isError(kotlinType)) {
            return kotlinType.getAttributes();
        }
        return typeAttributes.add(kotlinType.getAttributes());
    }

    private final void checkRepeatedAnnotations(Annotations iterable, Annotations object) {
        HashSet hashSet;
        Annotations annotations2 = iterable;
        iterable = hashSet;
        hashSet = new HashSet();
        Object object2 = annotations2.iterator();
        while (object2.hasNext()) {
            iterable.add(((AnnotationDescriptor)object2.next()).getFqName());
        }
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (AnnotationDescriptor)object.next();
            if (!((HashSet)iterable).contains(object2.getFqName())) continue;
            this.reportStrategy.repeatedAnnotation((AnnotationDescriptor)object2);
        }
    }

    private final SimpleType combineNullability(SimpleType simpleType2, KotlinType kotlinType) {
        SimpleType simpleType3 = TypeUtils.makeNullableIfNeeded(simpleType2, kotlinType.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue(simpleType3, "makeNullableIfNeeded(thi\u2026romType.isMarkedNullable)");
        return simpleType3;
    }

    private final SimpleType combineNullabilityAndAnnotations(SimpleType simpleType2, KotlinType kotlinType) {
        TypeAliasExpander typeAliasExpander = simpleType3;
        SimpleType simpleType3 = ((TypeAliasExpander)((Object)simpleType3)).combineNullability(simpleType2, kotlinType);
        return typeAliasExpander.combineAttributes(simpleType3, kotlinType.getAttributes());
    }

    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection object, TypeAliasExpansion object2, int n) {
        Object object3 = object.getType().unwrap();
        if (DynamicTypesKt.isDynamic((KotlinType)object3)) {
            return object;
        }
        if (!KotlinTypeKt.isError((KotlinType)(object3 = TypeSubstitutionKt.asSimpleType((KotlinType)object3))) && TypeUtilsKt.requiresTypeAliasExpansion((KotlinType)object3)) {
            Object object4;
            TypeConstructor typeConstructor2 = ((KotlinType)object3).getConstructor();
            ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
            boolean bl = typeConstructor2.getParameters().size() == ((KotlinType)object3).getArguments().size();
            if (_Assertions.ENABLED && !bl) {
                object4 = "Unexpected malformed type: " + object3;
                throw new AssertionError(object4);
            }
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                if (classifierDescriptor instanceof TypeAliasDescriptor) {
                    TypeProjectionImpl typeProjectionImpl;
                    ArrayList<TypeProjection> arrayList;
                    if (((TypeAliasExpansion)object2).isRecursion((TypeAliasDescriptor)(classifierDescriptor = (TypeAliasDescriptor)classifierDescriptor))) {
                        ((TypeAliasExpander)object4).reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)classifierDescriptor);
                        String[] stringArray = new String[1];
                        object4 = classifierDescriptor.getName().toString();
                        Intrinsics.checkNotNullExpressionValue(object4, "typeDescriptor.name.toString()");
                        stringArray[0] = object4;
                        return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, stringArray));
                    }
                    List list = ((KotlinType)object3).getArguments();
                    ArrayList<TypeProjection> arrayList2 = arrayList;
                    arrayList = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault(list, 10));
                    int n2 = 0;
                    for (Object t : list) {
                        int n3 = n2 + 1;
                        if (n2 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        arrayList2.add(super.expandTypeProjection((TypeProjection)t, (TypeAliasExpansion)object2, (TypeParameterDescriptor)typeConstructor2.getParameters().get(n2), n + 1));
                        n2 = n3;
                    }
                    Object object5 = object4;
                    UnwrappedType unwrappedType = object3;
                    Object object6 = object4;
                    UnwrappedType unwrappedType2 = object3;
                    object4 = TypeAliasExpansion.Companion.create((TypeAliasExpansion)object2, (TypeAliasDescriptor)classifierDescriptor, arrayList2);
                    object3 = unwrappedType2.getAttributes();
                    boolean bl2 = unwrappedType2.isMarkedNullable();
                    int n4 = n + 1;
                    SimpleType simpleType2 = super.expandRecursively((TypeAliasExpansion)object4, (TypeAttributes)object3, bl2, n4, false);
                    object2 = super.substituteArguments((SimpleType)unwrappedType, (TypeAliasExpansion)object2, n);
                    if (!DynamicTypesKt.isDynamic(simpleType2)) {
                        simpleType2 = SpecialTypesKt.withAbbreviation(simpleType2, (SimpleType)object2);
                    }
                    object2 = typeProjectionImpl;
                    typeProjectionImpl = new TypeProjectionImpl(object.getProjectionKind(), simpleType2);
                    object = object2;
                } else {
                    TypeProjectionImpl typeProjectionImpl;
                    TypeAliasExpander typeAliasExpander = object4;
                    object4 = ((TypeAliasExpander)object4).substituteArguments((SimpleType)object3, (TypeAliasExpansion)object2, n);
                    typeAliasExpander.checkTypeArgumentsSubstitution((KotlinType)object3, (KotlinType)object4);
                    object2 = typeProjectionImpl;
                    typeProjectionImpl = new TypeProjectionImpl(object.getProjectionKind(), (KotlinType)object4);
                    object = object2;
                }
            }
            return object;
        }
        return object;
    }

    private final SimpleType substituteArguments(SimpleType simpleType2, TypeAliasExpansion typeAliasExpansion, int n) {
        ArrayList<TypeProjection> arrayList;
        SimpleType simpleType3 = simpleType2;
        TypeConstructor typeConstructor2 = simpleType3.getConstructor();
        List list = simpleType3.getArguments();
        ArrayList<TypeProjection> arrayList2 = arrayList;
        arrayList = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault(list, 10));
        int n2 = 0;
        for (Object object : list) {
            TypeProjection typeProjection;
            int n3 = n2 + 1;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            if (!(typeProjection = this.expandTypeProjection((TypeProjection)(object = (TypeProjection)object), typeAliasExpansion, (TypeParameterDescriptor)typeConstructor2.getParameters().get(n2), n2 = n + 1)).isStarProjection()) {
                TypeProjectionImpl typeProjectionImpl;
                TypeProjectionImpl typeProjectionImpl2 = typeProjectionImpl;
                typeProjectionImpl = new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.makeNullableIfNeeded(typeProjection.getType(), object.getType().isMarkedNullable()));
                typeProjection = typeProjectionImpl2;
            }
            arrayList2.add(typeProjection);
            n2 = n3;
        }
        return TypeSubstitutionKt.replace$default(simpleType2, arrayList2, null, 2, null);
    }

    private final void checkTypeArgumentsSubstitution(KotlinType kotlinType, KotlinType object) {
        KotlinType kotlinType2 = object;
        object = TypeSubstitutor.create(kotlinType2);
        Intrinsics.checkNotNullExpressionValue(object, "create(substitutedType)");
        int n = 0;
        for (Object object2 : kotlinType2.getArguments()) {
            int n2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            if (!(object2 = (TypeProjection)object2).isStarProjection()) {
                KotlinType kotlinType3 = object2.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType3, "substitutedArgument.type");
                if (!TypeUtilsKt.containsTypeAliasParameters(kotlinType3)) {
                    KotlinType kotlinType4 = kotlinType;
                    Object object3 = (TypeProjection)kotlinType4.getArguments().get(n);
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)kotlinType4.getConstructor().getParameters().get(n);
                    if (this.shouldCheckBounds) {
                        Object object4 = object2;
                        object2 = object3.getType();
                        Intrinsics.checkNotNullExpressionValue(object2, "unsubstitutedArgument.type");
                        object3 = object4.getType();
                        Intrinsics.checkNotNullExpressionValue(object3, "substitutedArgument.type");
                        Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "typeParameter");
                        this.reportStrategy.boundsViolationInSubstitution((TypeSubstitutor)object, (KotlinType)object2, (KotlinType)object3, typeParameterDescriptor);
                    }
                }
            }
            n = n2;
        }
    }

    public final SimpleType expand(TypeAliasExpansion typeAliasExpansion, TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter(typeAliasExpansion, "typeAliasExpansion");
        Intrinsics.checkNotNullParameter(typeAttributes, "attributes");
        return this.expandRecursively(typeAliasExpansion, typeAttributes, false, 0, true);
    }
}

