/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Arrays;
import java.util.Collection;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.CheckResult;
import kotlin.reflect.jvm.internal.impl.util.CheckResult$IllegalSignature;
import kotlin.reflect.jvm.internal.impl.util.CheckResult$SuccessCheck;
import kotlin.reflect.jvm.internal.impl.util.Checks$2;
import kotlin.reflect.jvm.internal.impl.util.Checks$3;
import kotlin.reflect.jvm.internal.impl.util.Checks$4;
import kotlin.text.Regex;

public final class Checks {
    private final Name name;
    private final Regex regex;
    private final Collection nameList;
    private final Function1 additionalCheck;
    private final Check[] checks;

    private Checks(Name name, Regex regex, Collection collection, Function1 function1, Check ... checkArray) {
        this.name = name;
        this.regex = regex;
        this.nameList = collection;
        this.additionalCheck = function1;
        this.checks = checkArray;
    }

    public Checks(Name name, Check[] checkArray, Function1 function1) {
        Check[] checkArray2 = checkArray3;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(checkArray, "checks");
        Intrinsics.checkNotNullParameter(function1, "additionalChecks");
        Check[] checkArray3 = Arrays.copyOf(checkArray, checkArray.length);
        super(name, null, null, function1, checkArray3);
    }

    public /* synthetic */ Checks(Name name, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = Checks$2.INSTANCE;
        }
        this(name, checkArray, function1);
    }

    public Checks(Regex regex, Check[] checkArray, Function1 function1) {
        Check[] checkArray2 = checkArray3;
        Intrinsics.checkNotNullParameter(regex, "regex");
        Intrinsics.checkNotNullParameter(checkArray, "checks");
        Intrinsics.checkNotNullParameter(function1, "additionalChecks");
        Check[] checkArray3 = Arrays.copyOf(checkArray, checkArray.length);
        super(null, regex, null, function1, checkArray3);
    }

    public /* synthetic */ Checks(Regex regex, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = Checks$3.INSTANCE;
        }
        this(regex, checkArray, function1);
    }

    public Checks(Collection collection, Check[] checkArray, Function1 function1) {
        Check[] checkArray2 = checkArray3;
        Intrinsics.checkNotNullParameter(collection, "nameList");
        Intrinsics.checkNotNullParameter(checkArray, "checks");
        Intrinsics.checkNotNullParameter(function1, "additionalChecks");
        Check[] checkArray3 = Arrays.copyOf(checkArray, checkArray.length);
        super(null, null, collection, function1, checkArray3);
    }

    public /* synthetic */ Checks(Collection collection, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = Checks$4.INSTANCE;
        }
        this(collection, checkArray, function1);
    }

    public final boolean isApplicable(FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        if (((Checks)this).name != null && !Intrinsics.areEqual(functionDescriptor.getName(), ((Checks)this).name)) {
            return false;
        }
        if (((Checks)this).regex != null) {
            String string = functionDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "functionDescriptor.name.asString()");
            if (!((Checks)this).regex.matches(string)) {
                return false;
            }
        }
        return (this = ((Checks)this).nameList) == null || this.contains(functionDescriptor.getName());
    }

    public final CheckResult checkAll(FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Check[] checkArray = ((Checks)((Object)string)).checks;
        int n = ((Checks)((Object)string)).checks.length;
        for (int i = 0; i < n; ++i) {
            String string = checkArray[i].invoke(functionDescriptor);
            if (string == null) continue;
            return new CheckResult$IllegalSignature(string);
        }
        String string = (String)((Checks)((Object)string)).additionalCheck.invoke(functionDescriptor);
        if (string != null) {
            return new CheckResult$IllegalSignature(string);
        }
        return CheckResult$SuccessCheck.INSTANCE;
    }
}

