/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;

public abstract class CollectionsKt {
    public static final Map mapToIndex(Iterable object) {
        LinkedHashMap linkedHashMap;
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        Iterator iterator2 = iterable.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2 = n++;
            Object t = iterator2.next();
            object.put(t, n2);
        }
        return object;
    }

    public static final void addIfNotNull(Collection collection, Object object) {
        Intrinsics.checkNotNullParameter(collection, "<this>");
        if (object != null) {
            collection.add(object);
        }
    }

    public static final HashMap newHashMapWithExpectedSize(int n) {
        return new HashMap(CollectionsKt.capacity(n));
    }

    public static final HashSet newHashSetWithExpectedSize(int n) {
        return new HashSet(CollectionsKt.capacity(n));
    }

    public static final LinkedHashSet newLinkedHashSetWithExpectedSize(int n) {
        return new LinkedHashSet(CollectionsKt.capacity(n));
    }

    private static final int capacity(int n) {
        int n2;
        if (n < 3) {
            n2 = 3;
        } else {
            int n3 = n;
            n2 = n3 + n3 / 3 + 1;
        }
        return n2;
    }

    public static final List compact(ArrayList list) {
        ArrayList arrayList = list;
        Intrinsics.checkNotNullParameter(arrayList, "<this>");
        int n = arrayList.size();
        if (n != 0) {
            if (n != 1) {
                ((ArrayList)list).trimToSize();
            } else {
                list = kotlin.collections.CollectionsKt.listOf(kotlin.collections.CollectionsKt.first(list));
            }
        } else {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }
}

