/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.TlsVersion;

public final class ConnectionSpec$Builder {
    private boolean tls;
    private String[] cipherSuites;
    private String[] tlsVersions;
    private boolean supportsTlsExtensions;

    public ConnectionSpec$Builder(boolean bl) {
        this.tls = bl;
    }

    public ConnectionSpec$Builder(ConnectionSpec connectionSpec) {
        Intrinsics.checkNotNullParameter(connectionSpec, "connectionSpec");
        this.tls = connectionSpec.isTls();
        this.cipherSuites = ConnectionSpec.access$getCipherSuitesAsString$p(connectionSpec);
        this.tlsVersions = ConnectionSpec.access$getTlsVersionsAsString$p(connectionSpec);
        this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions();
    }

    public final boolean getTls$okhttp() {
        return this.tls;
    }

    public final void setCipherSuites$okhttp(String[] stringArray) {
        this.cipherSuites = stringArray;
    }

    public final void setTlsVersions$okhttp(String[] stringArray) {
        this.tlsVersions = stringArray;
    }

    public final void setSupportsTlsExtensions$okhttp(boolean bl) {
        this.supportsTlsExtensions = bl;
    }

    public final ConnectionSpec$Builder cipherSuites(CipherSuite ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "cipherSuites");
        if (this.getTls$okhttp()) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(objectArray[i].javaName());
            }
            objectArray = arrayList2.toArray(new String[0]);
            if (objectArray != null) {
                String[] stringArray = (String[])objectArray;
                return this.cipherSuites(Arrays.copyOf(stringArray, stringArray.length));
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder cipherSuites(String ... stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "cipherSuites");
        if (this.getTls$okhttp()) {
            boolean bl = stringArray.length == 0;
            if (bl ^ true) {
                ConnectionSpec$Builder connectionSpec$Builder = this;
                connectionSpec$Builder.setCipherSuites$okhttp((String[])stringArray.clone());
                return connectionSpec$Builder;
            }
            throw new IllegalArgumentException("At least one cipher suite is required".toString());
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder tlsVersions(TlsVersion ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "tlsVersions");
        if (this.getTls$okhttp()) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(objectArray[i].javaName());
            }
            objectArray = arrayList2.toArray(new String[0]);
            if (objectArray != null) {
                String[] stringArray = (String[])objectArray;
                return this.tlsVersions(Arrays.copyOf(stringArray, stringArray.length));
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder tlsVersions(String ... stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "tlsVersions");
        if (this.getTls$okhttp()) {
            boolean bl = stringArray.length == 0;
            if (bl ^ true) {
                ConnectionSpec$Builder connectionSpec$Builder = this;
                connectionSpec$Builder.setTlsVersions$okhttp((String[])stringArray.clone());
                return connectionSpec$Builder;
            }
            throw new IllegalArgumentException("At least one TLS version is required".toString());
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder supportsTlsExtensions(boolean bl) {
        if (this.getTls$okhttp()) {
            ConnectionSpec$Builder connectionSpec$Builder = this;
            connectionSpec$Builder.setSupportsTlsExtensions$okhttp(bl);
            return connectionSpec$Builder;
        }
        throw new IllegalArgumentException("no TLS extensions for cleartext connections".toString());
    }

    public final ConnectionSpec build() {
        ConnectionSpec$Builder connectionSpec$Builder = this;
        boolean bl = connectionSpec$Builder.tls;
        boolean bl2 = connectionSpec$Builder.supportsTlsExtensions;
        String[] stringArray = connectionSpec$Builder.cipherSuites;
        String[] stringArray2 = connectionSpec$Builder.tlsVersions;
        return new ConnectionSpec(bl, bl2, stringArray, stringArray2);
    }
}

