/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import kotlin.jvm.internal.Intrinsics;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Headers$Builder;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.Exchange;

public class Response$Builder {
    private Request request;
    private Protocol protocol;
    private int code;
    private String message;
    private Handshake handshake;
    private Headers$Builder headers;
    private ResponseBody body;
    private Response networkResponse;
    private Response cacheResponse;
    private Response priorResponse;
    private long sentRequestAtMillis;
    private long receivedResponseAtMillis;
    private Exchange exchange;

    public Response$Builder() {
        Headers$Builder headers$Builder;
        ((Response$Builder)((Object)headers$Builder2)).code = -1;
        Headers$Builder headers$Builder2 = headers$Builder;
        headers$Builder = new Headers$Builder();
        v1.headers = headers$Builder2;
    }

    public Response$Builder(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        this.code = -1;
        this.request = response.request();
        this.protocol = response.protocol();
        this.code = response.code();
        this.message = response.message();
        this.handshake = response.handshake();
        this.headers = response.headers().newBuilder();
        this.body = response.body();
        this.networkResponse = response.networkResponse();
        this.cacheResponse = response.cacheResponse();
        this.priorResponse = response.priorResponse();
        this.sentRequestAtMillis = response.sentRequestAtMillis();
        this.receivedResponseAtMillis = response.receivedResponseAtMillis();
        this.exchange = response.exchange();
    }

    private final void checkSupportResponse(String string, Response response) {
        Object object;
        block3: {
            block4: {
                block5: {
                    block6: {
                        block2: {
                            if (response == null) break block2;
                            if (!(response.body() == null)) break block3;
                            if (!(response.networkResponse() == null)) break block4;
                            if (!(response.cacheResponse() == null)) break block5;
                            if (!(response.priorResponse() == null)) break block6;
                        }
                        return;
                    }
                    object = Intrinsics.stringPlus(string, ".priorResponse != null");
                    throw new IllegalArgumentException(object.toString());
                }
                object = Intrinsics.stringPlus(string, ".cacheResponse != null");
                throw new IllegalArgumentException(object.toString());
            }
            object = Intrinsics.stringPlus(string, ".networkResponse != null");
            throw new IllegalArgumentException(object.toString());
        }
        object = Intrinsics.stringPlus(string, ".body != null");
        throw new IllegalArgumentException(object.toString());
    }

    private final void checkPriorResponse(Response response) {
        if (response == null || response.body() == null) {
            return;
        }
        throw new IllegalArgumentException("priorResponse.body != null".toString());
    }

    public final void setRequest$okhttp(Request request) {
        this.request = request;
    }

    public final void setProtocol$okhttp(Protocol protocol) {
        this.protocol = protocol;
    }

    public final int getCode$okhttp() {
        return this.code;
    }

    public final void setCode$okhttp(int n) {
        this.code = n;
    }

    public final void setMessage$okhttp(String string) {
        this.message = string;
    }

    public final void setHandshake$okhttp(Handshake handshake2) {
        this.handshake = handshake2;
    }

    public final Headers$Builder getHeaders$okhttp() {
        return this.headers;
    }

    public final void setHeaders$okhttp(Headers$Builder headers$Builder) {
        Intrinsics.checkNotNullParameter(headers$Builder, "<set-?>");
        this.headers = headers$Builder;
    }

    public final void setBody$okhttp(ResponseBody responseBody) {
        this.body = responseBody;
    }

    public final void setNetworkResponse$okhttp(Response response) {
        this.networkResponse = response;
    }

    public final void setCacheResponse$okhttp(Response response) {
        this.cacheResponse = response;
    }

    public final void setPriorResponse$okhttp(Response response) {
        this.priorResponse = response;
    }

    public final void setSentRequestAtMillis$okhttp(long l) {
        this.sentRequestAtMillis = l;
    }

    public final void setReceivedResponseAtMillis$okhttp(long l) {
        this.receivedResponseAtMillis = l;
    }

    public Response$Builder request(Request request) {
        Response$Builder response$Builder = this;
        Intrinsics.checkNotNullParameter(request, "request");
        response$Builder.setRequest$okhttp(request);
        return response$Builder;
    }

    public Response$Builder protocol(Protocol protocol) {
        Response$Builder response$Builder = this;
        Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
        response$Builder.setProtocol$okhttp(protocol);
        return response$Builder;
    }

    public Response$Builder code(int n) {
        Response$Builder response$Builder = this;
        response$Builder.setCode$okhttp(n);
        return response$Builder;
    }

    public Response$Builder message(String string) {
        Response$Builder response$Builder = this;
        Intrinsics.checkNotNullParameter(string, "message");
        response$Builder.setMessage$okhttp(string);
        return response$Builder;
    }

    public Response$Builder handshake(Handshake handshake2) {
        Response$Builder response$Builder = this;
        response$Builder.setHandshake$okhttp(handshake2);
        return response$Builder;
    }

    public Response$Builder header(String string, String string2) {
        Response$Builder response$Builder = this;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(string2, "value");
        response$Builder.getHeaders$okhttp().set(string, string2);
        return response$Builder;
    }

    public Response$Builder addHeader(String string, String string2) {
        Response$Builder response$Builder = this;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(string2, "value");
        response$Builder.getHeaders$okhttp().add(string, string2);
        return response$Builder;
    }

    public Response$Builder headers(Headers headers) {
        Response$Builder response$Builder = this;
        Headers headers2 = headers;
        Intrinsics.checkNotNullParameter(headers2, "headers");
        response$Builder.setHeaders$okhttp(headers2.newBuilder());
        return response$Builder;
    }

    public Response$Builder body(ResponseBody responseBody) {
        Response$Builder response$Builder = this;
        response$Builder.setBody$okhttp(responseBody);
        return response$Builder;
    }

    public Response$Builder networkResponse(Response response) {
        Response$Builder response$Builder = this;
        response$Builder.checkSupportResponse("networkResponse", response);
        response$Builder.setNetworkResponse$okhttp(response);
        return response$Builder;
    }

    public Response$Builder cacheResponse(Response response) {
        Response$Builder response$Builder = this;
        response$Builder.checkSupportResponse("cacheResponse", response);
        response$Builder.setCacheResponse$okhttp(response);
        return response$Builder;
    }

    public Response$Builder priorResponse(Response response) {
        Response$Builder response$Builder = this;
        response$Builder.checkPriorResponse(response);
        response$Builder.setPriorResponse$okhttp(response);
        return response$Builder;
    }

    public Response$Builder sentRequestAtMillis(long l) {
        Response$Builder response$Builder = this;
        response$Builder.setSentRequestAtMillis$okhttp(l);
        return response$Builder;
    }

    public Response$Builder receivedResponseAtMillis(long l) {
        Response$Builder response$Builder = this;
        response$Builder.setReceivedResponseAtMillis$okhttp(l);
        return response$Builder;
    }

    public final void initExchange$okhttp(Exchange exchange) {
        Intrinsics.checkNotNullParameter(exchange, "deferredTrailers");
        this.exchange = exchange;
    }

    public Response build() {
        Object object;
        int n = ((Response$Builder)object).code;
        if (n >= 0) {
            Request request = ((Response$Builder)object).request;
            if (request != null) {
                Protocol protocol = ((Response$Builder)object).protocol;
                if (protocol != null) {
                    String string = ((Response$Builder)object).message;
                    if (string != null) {
                        Object object2 = object;
                        object = ((Response$Builder)object2).handshake;
                        Headers headers = ((Response$Builder)object2).headers.build();
                        ResponseBody responseBody = ((Response$Builder)object2).body;
                        Response response = ((Response$Builder)object2).networkResponse;
                        Response response2 = ((Response$Builder)object2).cacheResponse;
                        Response response3 = ((Response$Builder)object2).priorResponse;
                        long l = ((Response$Builder)object2).sentRequestAtMillis;
                        long l2 = ((Response$Builder)object2).receivedResponseAtMillis;
                        Exchange exchange = ((Response$Builder)object2).exchange;
                        return new Response(request, protocol, string, n, (Handshake)object, headers, responseBody, response, response2, response3, l, l2, exchange);
                    }
                    throw new IllegalStateException("message == null".toString());
                }
                throw new IllegalStateException("protocol == null".toString());
            }
            throw new IllegalStateException("request == null".toString());
        }
        object = Intrinsics.stringPlus("code < 0: ", ((Response$Builder)object).getCode$okhttp());
        throw new IllegalStateException(object.toString());
    }
}

