/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;

public final class ConnectionSpecSelector {
    private final List connectionSpecs;
    private int nextModeIndex;
    private boolean isFallbackPossible;
    private boolean isFallback;

    public ConnectionSpecSelector(List list) {
        Intrinsics.checkNotNullParameter(list, "connectionSpecs");
        this.connectionSpecs = list;
    }

    private final boolean isFallbackPossible(SSLSocket sSLSocket) {
        ConnectionSpecSelector connectionSpecSelector = this;
        int n = connectionSpecSelector.nextModeIndex;
        int n2 = connectionSpecSelector.connectionSpecs.size();
        while (n < n2) {
            int n3 = n + 1;
            if (((ConnectionSpec)this.connectionSpecs.get(n)).isCompatible(sSLSocket)) {
                return true;
            }
            n = n3;
        }
        return false;
    }

    public final ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) {
        ConnectionSpecSelector connectionSpecSelector = this;
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        ConnectionSpec connectionSpec = null;
        int n = connectionSpecSelector.nextModeIndex;
        int n2 = connectionSpecSelector.connectionSpecs.size();
        while (n < n2) {
            int n3 = n + 1;
            ConnectionSpec connectionSpec2 = (ConnectionSpec)this.connectionSpecs.get(n);
            if (connectionSpec2.isCompatible(sSLSocket)) {
                this.nextModeIndex = n3;
                connectionSpec = connectionSpec2;
                break;
            }
            n = n3;
        }
        if (connectionSpec != null) {
            ConnectionSpec connectionSpec3 = connectionSpec;
            ConnectionSpecSelector connectionSpecSelector2 = this;
            connectionSpecSelector2.isFallbackPossible = connectionSpecSelector2.isFallbackPossible(sSLSocket);
            connectionSpec3.apply$okhttp(sSLSocket, connectionSpecSelector2.isFallback);
            return connectionSpec3;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unable to find acceptable protocols. isFallback=").append(this.isFallback).append(", modes=").append(this.connectionSpecs).append(", supported protocols=");
        Object[] objectArray = sSLSocket.getEnabledProtocols();
        Intrinsics.checkNotNull(objectArray);
        String string = Arrays.toString(objectArray);
        Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
        throw new UnknownServiceException(stringBuilder.append(string).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean connectionFailed(IOException iOException) {
        Intrinsics.checkNotNullParameter(iOException, "e");
        this.isFallback = true;
        if (!this.isFallbackPossible) return false;
        if (!(iOException instanceof ProtocolException || iOException instanceof InterruptedIOException || iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException || iOException instanceof SSLPeerUnverifiedException)) {
            if (iOException instanceof SSLException) return true;
        }
        return false;
    }
}

