/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.EventListener;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.Exchange$RequestBodySink;
import okhttp3.internal.connection.Exchange$ResponseBodySource;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Exchange {
    private final RealCall call;
    private final EventListener eventListener;
    private final ExchangeFinder finder;
    private final ExchangeCodec codec;
    private boolean isDuplex;
    private final RealConnection connection;

    public Exchange(RealCall realCall, EventListener eventListener, ExchangeFinder exchangeFinder, ExchangeCodec exchangeCodec) {
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        Intrinsics.checkNotNullParameter(exchangeFinder, "finder");
        Intrinsics.checkNotNullParameter(exchangeCodec, "codec");
        this.call = realCall;
        this.eventListener = eventListener;
        this.finder = exchangeFinder;
        this.codec = exchangeCodec;
        this.connection = exchangeCodec.getConnection();
    }

    private final void trackFailure(IOException iOException) {
        Exchange exchange = this;
        exchange.finder.trackFailure(iOException);
        exchange.codec.getConnection().trackFailure$okhttp(this.call, iOException);
    }

    public final RealCall getCall$okhttp() {
        return this.call;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final ExchangeFinder getFinder$okhttp() {
        return this.finder;
    }

    public final boolean isDuplex$okhttp() {
        return this.isDuplex;
    }

    public final RealConnection getConnection$okhttp() {
        return this.connection;
    }

    public final boolean isCoalescedConnection$okhttp() {
        return Intrinsics.areEqual(this.finder.getAddress$okhttp().url().host(), this.connection.route().address().url().host()) ^ true;
    }

    public final void writeRequestHeaders(Request request) {
        Exchange exchange = this;
        Intrinsics.checkNotNullParameter(request, "request");
        try {
            exchange.eventListener.requestHeadersStart(this.call);
            exchange.codec.writeRequestHeaders(request);
            exchange.eventListener.requestHeadersEnd(this.call, request);
            return;
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public final Sink createRequestBody(Request object, boolean bl) {
        Exchange exchange = this;
        Intrinsics.checkNotNullParameter(object, "request");
        this.isDuplex = bl;
        RequestBody requestBody = ((Request)object).body();
        Intrinsics.checkNotNull(requestBody);
        long l = requestBody.contentLength();
        exchange.eventListener.requestBodyStart(this.call);
        object = exchange.codec.createRequestBody((Request)object, l);
        return new Exchange$RequestBodySink(this, (Sink)object, l);
    }

    public final void flushRequest() {
        try {
            this.codec.flushRequest();
            return;
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public final void finishRequest() {
        try {
            this.codec.finishRequest();
            return;
        }
        catch (IOException iOException) {
            this.eventListener.requestFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
    }

    public final void responseHeadersStart() {
        this.eventListener.responseHeadersStart(this.call);
    }

    public final Response$Builder readResponseHeaders(boolean bl) {
        Response$Builder response$Builder;
        block3: {
            try {
                response$Builder = this.codec.readResponseHeaders(bl);
                if (response$Builder == null) break block3;
            }
            catch (IOException iOException) {
                this.eventListener.responseFailed(this.call, iOException);
                this.trackFailure(iOException);
                throw iOException;
            }
            response$Builder.initExchange$okhttp(this);
        }
        return response$Builder;
    }

    public final void responseHeadersEnd(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        this.eventListener.responseHeadersEnd(this.call, response);
    }

    public final ResponseBody openResponseBody(Response closeable) {
        RealResponseBody realResponseBody;
        Exchange$ResponseBodySource exchange$ResponseBodySource;
        String string;
        Exchange exchange = this;
        Response response = closeable;
        Intrinsics.checkNotNullParameter(response, "response");
        try {
            string = Response.header$default(response, "Content-Type", null, 2, null);
        }
        catch (IOException iOException) {
            this.eventListener.responseFailed(this.call, iOException);
            this.trackFailure(iOException);
            throw iOException;
        }
        long l = exchange.codec.reportedContentLength((Response)closeable);
        closeable = exchange.codec.openResponseBodySource((Response)closeable);
        Exchange$ResponseBodySource exchange$ResponseBodySource2 = exchange$ResponseBodySource;
        exchange$ResponseBodySource = new Exchange$ResponseBodySource(this, (Source)closeable, l);
        RealResponseBody realResponseBody2 = realResponseBody;
        RealResponseBody realResponseBody3 = realResponseBody;
        String string2 = string;
        closeable = Okio.buffer(exchange$ResponseBodySource2);
        realResponseBody2(string2, l, (BufferedSource)closeable);
        return realResponseBody3;
    }

    public final void noNewExchangesOnConnection() {
        this.codec.getConnection().noNewExchanges$okhttp();
    }

    public final void cancel() {
        this.codec.cancel();
    }

    public final void detachWithViolence() {
        Exchange exchange = this;
        exchange.codec.cancel();
        exchange.call.messageDone$okhttp(this, true, true, null);
    }

    public final IOException bodyComplete(long l, boolean bl, boolean bl2, IOException iOException) {
        if (iOException != null) {
            this.trackFailure(iOException);
        }
        if (bl2) {
            if (iOException != null) {
                this.eventListener.requestFailed(this.call, iOException);
            } else {
                this.eventListener.requestBodyEnd(this.call, l);
            }
        }
        if (bl) {
            if (iOException != null) {
                this.eventListener.responseFailed(this.call, iOException);
            } else {
                this.eventListener.responseBodyEnd(this.call, l);
            }
        }
        return this.call.messageDone$okhttp(this, bl2, bl, iOException);
    }

    public final void noRequestBody() {
        this.call.messageDone$okhttp(this, true, false, null);
    }
}

