/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSink;
import okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSource;
import okhttp3.internal.http1.Http1ExchangeCodec$Companion;
import okhttp3.internal.http1.Http1ExchangeCodec$FixedLengthSource;
import okhttp3.internal.http1.Http1ExchangeCodec$KnownLengthSink;
import okhttp3.internal.http1.Http1ExchangeCodec$UnknownLengthSource;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http1ExchangeCodec
implements ExchangeCodec {
    public static final Http1ExchangeCodec$Companion Companion = new Http1ExchangeCodec$Companion(null);
    private final OkHttpClient client;
    private final RealConnection connection;
    private final BufferedSource source;
    private final BufferedSink sink;
    private int state;
    private final HeadersReader headersReader;
    private Headers trailers;

    public Http1ExchangeCodec(OkHttpClient okHttpClient, RealConnection realConnection, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        HeadersReader headersReader;
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(bufferedSink, "sink");
        ((Http1ExchangeCodec)((Object)headersReader2)).client = okHttpClient;
        ((Http1ExchangeCodec)((Object)headersReader2)).connection = realConnection;
        ((Http1ExchangeCodec)((Object)headersReader2)).source = bufferedSource;
        ((Http1ExchangeCodec)((Object)headersReader2)).sink = bufferedSink;
        HeadersReader headersReader2 = headersReader;
        headersReader = new HeadersReader(bufferedSource);
        v1.headersReader = headersReader2;
    }

    private final boolean isChunked(Response response) {
        return StringsKt.equals("chunked", Response.header$default(response, "Transfer-Encoding", null, 2, null), true);
    }

    private final boolean isChunked(Request request) {
        return StringsKt.equals("chunked", request.header("Transfer-Encoding"), true);
    }

    private final Sink newChunkedSink() {
        int n = ((Http1ExchangeCodec)((Object)string)).state;
        if (n == 1) {
            ((Http1ExchangeCodec)((Object)string)).state = 2;
            return new Http1ExchangeCodec$ChunkedSink((Http1ExchangeCodec)((Object)string));
        }
        String string = Intrinsics.stringPlus("state: ", n);
        throw new IllegalStateException(string.toString());
    }

    private final Sink newKnownLengthSink() {
        int n = ((Http1ExchangeCodec)((Object)string)).state;
        if (n == 1) {
            ((Http1ExchangeCodec)((Object)string)).state = 2;
            return new Http1ExchangeCodec$KnownLengthSink((Http1ExchangeCodec)((Object)string));
        }
        String string = Intrinsics.stringPlus("state: ", n);
        throw new IllegalStateException(string.toString());
    }

    private final Source newFixedLengthSource(long l) {
        int n = ((Http1ExchangeCodec)((Object)string)).state;
        if (n == 4) {
            ((Http1ExchangeCodec)((Object)string)).state = 5;
            return new Http1ExchangeCodec$FixedLengthSource((Http1ExchangeCodec)((Object)string), l);
        }
        String string = Intrinsics.stringPlus("state: ", n);
        throw new IllegalStateException(string.toString());
    }

    private final Source newChunkedSource(HttpUrl httpUrl) {
        int n = ((Http1ExchangeCodec)((Object)string)).state;
        if (n == 4) {
            ((Http1ExchangeCodec)((Object)string)).state = 5;
            return new Http1ExchangeCodec$ChunkedSource((Http1ExchangeCodec)((Object)string), httpUrl);
        }
        String string = Intrinsics.stringPlus("state: ", n);
        throw new IllegalStateException(string.toString());
    }

    private final Source newUnknownLengthSource() {
        int n = ((Http1ExchangeCodec)((Object)string)).state;
        if (n == 4) {
            ((Http1ExchangeCodec)((Object)string)).state = 5;
            ((Http1ExchangeCodec)((Object)string)).getConnection().noNewExchanges$okhttp();
            return new Http1ExchangeCodec$UnknownLengthSource((Http1ExchangeCodec)((Object)string));
        }
        String string = Intrinsics.stringPlus("state: ", n);
        throw new IllegalStateException(string.toString());
    }

    private final void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout2 = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout2.clearDeadline();
        timeout2.clearTimeout();
    }

    public static final /* synthetic */ BufferedSink access$getSink$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.sink;
    }

    public static final /* synthetic */ void access$detachTimeout(Http1ExchangeCodec http1ExchangeCodec, ForwardingTimeout forwardingTimeout) {
        http1ExchangeCodec.detachTimeout(forwardingTimeout);
    }

    public static final /* synthetic */ void access$setState$p(Http1ExchangeCodec http1ExchangeCodec, int n) {
        http1ExchangeCodec.state = n;
    }

    public static final /* synthetic */ BufferedSource access$getSource$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.source;
    }

    public static final /* synthetic */ int access$getState$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.state;
    }

    public static final /* synthetic */ void access$setTrailers$p(Http1ExchangeCodec http1ExchangeCodec, Headers headers) {
        http1ExchangeCodec.trailers = headers;
    }

    public static final /* synthetic */ HeadersReader access$getHeadersReader$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.headersReader;
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.client;
    }

    public static final /* synthetic */ Headers access$getTrailers$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.trailers;
    }

    @Override
    public RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public Sink createRequestBody(Request request, long l) {
        block6: {
            Sink sink2;
            block5: {
                block4: {
                    Request request2 = request;
                    Intrinsics.checkNotNullParameter(request2, "request");
                    if (request2.body() != null && request.body().isDuplex()) {
                        throw new ProtocolException("Duplex connections are not supported for HTTP/1");
                    }
                    if (!this.isChunked(request)) break block4;
                    sink2 = this.newChunkedSink();
                    break block5;
                }
                if (l == -1L) break block6;
                sink2 = this.newKnownLengthSink();
            }
            return sink2;
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void cancel() {
        this.getConnection().cancel();
    }

    @Override
    public void writeRequestHeaders(Request request) {
        Http1ExchangeCodec http1ExchangeCodec = object;
        Request request2 = request;
        Intrinsics.checkNotNullParameter(request2, "request");
        Object object = object.getConnection().route().proxy().type();
        Intrinsics.checkNotNullExpressionValue(object, "connection.route().proxy.type()");
        object = RequestLine.INSTANCE.get(request, (Proxy.Type)((Object)object));
        http1ExchangeCodec.writeRequest(request2.headers(), (String)object);
    }

    @Override
    public long reportedContentLength(Response response) {
        Response response2 = response;
        Intrinsics.checkNotNullParameter(response2, "response");
        return !HttpHeaders.promisesBody(response2) ? 0L : (this.isChunked(response) ? -1L : Util.headersContentLength(response));
    }

    @Override
    public Source openResponseBodySource(Response response) {
        long l;
        Response response2 = response;
        Intrinsics.checkNotNullParameter(response2, "response");
        return !HttpHeaders.promisesBody(response2) ? this.newFixedLengthSource(0L) : (this.isChunked(response) ? this.newChunkedSource(response.request().url()) : ((l = Util.headersContentLength(response)) != -1L ? this.newFixedLengthSource(l) : this.newUnknownLengthSource()));
    }

    @Override
    public void flushRequest() {
        this.sink.flush();
    }

    @Override
    public void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(Headers headers, String string) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(string, "requestLine");
        int n = ((Http1ExchangeCodec)((Object)string2)).state;
        if (n == 0) {
            ((Http1ExchangeCodec)((Object)string2)).sink.writeUtf8(string).writeUtf8("\r\n");
            int n2 = 0;
            n = headers.size();
            while (n2 < n) {
                int n3 = n2 + 1;
                ((Http1ExchangeCodec)((Object)string2)).sink.writeUtf8(headers.name(n2)).writeUtf8(": ").writeUtf8(headers.value(n2)).writeUtf8("\r\n");
                n2 = n3;
            }
            ((Http1ExchangeCodec)((Object)string2)).sink.writeUtf8("\r\n");
            ((Http1ExchangeCodec)((Object)string2)).state = 1;
            return;
        }
        String string2 = Intrinsics.stringPlus("state: ", n);
        throw new IllegalStateException(string2.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response$Builder readResponseHeaders(boolean bl) {
        StatusLine statusLine;
        boolean bl2;
        Object object;
        int n = ((Http1ExchangeCodec)object).state;
        if (!(n == 1 || n == 3)) {
            object = Intrinsics.stringPlus("state: ", n);
            throw new IllegalStateException(object.toString());
        }
        try {
            bl2 = bl;
            statusLine = StatusLine.Companion.parse(((Http1ExchangeCodec)object).headersReader.readLine());
        }
        catch (EOFException eOFException) {
            object = ((Http1ExchangeCodec)object).getConnection().route().address().url().redact();
            throw new IOException(Intrinsics.stringPlus("unexpected end of stream on ", object), eOFException);
        }
        {
            Response$Builder response$Builder = new Response$Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(((Http1ExchangeCodec)object).headersReader.readHeaders());
            if (bl2 && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                ((Http1ExchangeCodec)object).state = 3;
                return response$Builder;
            }
            ((Http1ExchangeCodec)object).state = 4;
            return response$Builder;
        }
    }

    public final void skipConnectBody(Response response) {
        Response response2 = response;
        Intrinsics.checkNotNullParameter(response2, "response");
        long l = Util.headersContentLength(response2);
        if (l == -1L) {
            return;
        }
        Source source2 = this.newFixedLengthSource(l);
        Util.skipAll(source2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        source2.close();
    }
}

