/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

public final class Hpack$Reader {
    private final int headerTableSizeSetting;
    private int maxDynamicTableByteCount;
    private final List headerList;
    private final BufferedSource source;
    public Header[] dynamicTable;
    private int nextHeaderIndex;
    public int headerCount;
    public int dynamicTableByteCount;

    public Hpack$Reader(Source source2, int n, int n2) {
        Header[] headerArray = headerArray2;
        Intrinsics.checkNotNullParameter(source2, "source");
        headerArray2.headerTableSizeSetting = n;
        headerArray2.maxDynamicTableByteCount = n2;
        headerArray2.headerList = new ArrayList();
        headerArray.source = Okio.buffer(source2);
        Header[] headerArray2 = new Header[8];
        headerArray.dynamicTable = headerArray2;
        headerArray2.nextHeaderIndex = headerArray2.length - 1;
    }

    public /* synthetic */ Hpack$Reader(Source source2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        this(source2, n, n2);
    }

    private final void adjustDynamicTableByteCount() {
        int n = this.maxDynamicTableByteCount;
        int n2 = this.dynamicTableByteCount;
        if (n < n2) {
            if (n == 0) {
                this.clearDynamicTable();
            } else {
                this.evictToRecoverBytes(n2 - n);
            }
        }
    }

    private final void clearDynamicTable() {
        Hpack$Reader hpack$Reader = this;
        ArraysKt.fill$default(hpack$Reader.dynamicTable, null, 0, 0, 6, null);
        hpack$Reader.nextHeaderIndex = hpack$Reader.dynamicTable.length - 1;
        hpack$Reader.headerCount = 0;
        hpack$Reader.dynamicTableByteCount = 0;
    }

    private final int evictToRecoverBytes(int n) {
        int n2 = 0;
        if (n > 0) {
            int n3;
            int n4;
            for (n4 = this.dynamicTable.length - 1; n4 >= (n3 = this.nextHeaderIndex) && n > 0; --n4) {
                Hpack$Reader hpack$Reader = this;
                int n5 = n;
                Header header = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header);
                n = header.hpackSize;
                n3 = n5 - n;
                hpack$Reader.dynamicTableByteCount -= n;
                hpack$Reader.headerCount += -1;
                n = n2 + 1;
                n2 = n;
                n = n3;
            }
            Hpack$Reader hpack$Reader = this;
            int n6 = n3;
            int n7 = n6 + 1;
            n = n6 + 1 + n2;
            n4 = this.headerCount;
            System.arraycopy(hpack$Reader.dynamicTable, n7, hpack$Reader.dynamicTable, n, n4);
            hpack$Reader.nextHeaderIndex += n2;
        }
        return n2;
    }

    private final void readIndexedHeader(int n) {
        block4: {
            block3: {
                block2: {
                    if (!((Hpack$Reader)((Object)header)).isStaticHeader(n)) break block2;
                    Hpack$Reader hpack$Reader = header;
                    Header header = Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n];
                    hpack$Reader.headerList.add(header);
                    break block3;
                }
                int n2 = ((Hpack$Reader)((Object)header)).dynamicTableIndex(n - Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length);
                if (n2 < 0) break block4;
                Header[] headerArray = ((Hpack$Reader)((Object)header)).dynamicTable;
                if (n2 >= ((Hpack$Reader)((Object)header)).dynamicTable.length) break block4;
                Header header = headerArray[n2];
                Intrinsics.checkNotNull(header);
                ((Hpack$Reader)((Object)header)).headerList.add(header);
            }
            return;
        }
        throw new IOException(Intrinsics.stringPlus("Header index too large ", n + 1));
    }

    private final int dynamicTableIndex(int n) {
        return this.nextHeaderIndex + 1 + n;
    }

    private final void readLiteralHeaderWithoutIndexingIndexedName(int n) {
        Hpack$Reader hpack$Reader = byteString;
        ByteString byteString = hpack$Reader.getName(n);
        ByteString byteString2 = hpack$Reader.readByteString();
        hpack$Reader.headerList.add(new Header(byteString, byteString2));
    }

    private final void readLiteralHeaderWithoutIndexingNewName() {
        Hpack$Reader hpack$Reader = byteString;
        ByteString byteString = Hpack.INSTANCE.checkLowercase(((Hpack$Reader)((Object)byteString)).readByteString());
        ByteString byteString2 = hpack$Reader.readByteString();
        hpack$Reader.headerList.add(new Header(byteString, byteString2));
    }

    private final void readLiteralHeaderWithIncrementalIndexingIndexedName(int n) {
        Header header;
        Hpack$Reader hpack$Reader = byteString;
        ByteString byteString = hpack$Reader.getName(n);
        ByteString byteString2 = hpack$Reader.readByteString();
        Header header2 = header;
        header = new Header(byteString, byteString2);
        hpack$Reader.insertIntoDynamicTable(-1, header2);
    }

    private final void readLiteralHeaderWithIncrementalIndexingNewName() {
        Header header;
        Hpack$Reader hpack$Reader = byteString;
        ByteString byteString = Hpack.INSTANCE.checkLowercase(((Hpack$Reader)((Object)byteString)).readByteString());
        ByteString byteString2 = hpack$Reader.readByteString();
        Header header2 = header;
        header = new Header(byteString, byteString2);
        hpack$Reader.insertIntoDynamicTable(-1, header2);
    }

    private final ByteString getName(int n) {
        block4: {
            ByteString byteString;
            block3: {
                block2: {
                    if (!headerArray.isStaticHeader(n)) break block2;
                    byteString = Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n].name;
                    break block3;
                }
                int n2 = headerArray.dynamicTableIndex(n - Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length);
                if (n2 < 0) break block4;
                Header[] headerArray = headerArray.dynamicTable;
                if (n2 >= headerArray.dynamicTable.length) break block4;
                Header header = headerArray[n2];
                Intrinsics.checkNotNull(header);
                byteString = header.name;
            }
            return byteString;
        }
        throw new IOException(Intrinsics.stringPlus("Header index too large ", n + 1));
    }

    private final boolean isStaticHeader(int n) {
        return n >= 0 && n <= Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length - 1;
    }

    private final void insertIntoDynamicTable(int n, Header header) {
        int n2;
        this.headerList.add(header);
        int n3 = header.hpackSize;
        if (n != -1) {
            Header header2 = this.dynamicTable[this.dynamicTableIndex(n)];
            Intrinsics.checkNotNull(header2);
            n3 -= header2.hpackSize;
        }
        if (n3 > (n2 = this.maxDynamicTableByteCount)) {
            this.clearDynamicTable();
            return;
        }
        Hpack$Reader hpack$Reader = this;
        n2 = hpack$Reader.evictToRecoverBytes(hpack$Reader.dynamicTableByteCount + n3 - n2);
        if (n == -1) {
            Header[] headerArray = this.dynamicTable;
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray2 = headerArray;
                headerArray = new Header[headerArray.length * 2];
                n2 = headerArray2.length;
                int n4 = headerArray.length;
                System.arraycopy(headerArray2, 0, headerArray, n2, n4);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            Hpack$Reader hpack$Reader2 = this;
            int n5 = hpack$Reader2.nextHeaderIndex;
            hpack$Reader2.nextHeaderIndex = n5 + -1;
            hpack$Reader2.dynamicTable[n5] = header;
            ++hpack$Reader2.headerCount;
        } else {
            n += this.dynamicTableIndex(n) + n2;
            this.dynamicTable[n] = header;
        }
        this.dynamicTableByteCount += n3;
    }

    private final int readByte() {
        return Util.and(this.source.readByte(), 255);
    }

    public final List getAndResetHeaderList() {
        List list = CollectionsKt.toList(this.headerList);
        this.headerList.clear();
        return list;
    }

    public final void readHeaders() {
        while (!this.source.exhausted()) {
            int n = Util.and(this.source.readByte(), 255);
            if (n != 128) {
                if ((n & 0x80) == 128) {
                    Hpack$Reader hpack$Reader = this;
                    hpack$Reader.readIndexedHeader(hpack$Reader.readInt(n, 127) - 1);
                    continue;
                }
                if (n == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((n & 0x40) == 64) {
                    Hpack$Reader hpack$Reader = this;
                    hpack$Reader.readLiteralHeaderWithIncrementalIndexingIndexedName(hpack$Reader.readInt(n, 63) - 1);
                    continue;
                }
                if ((n & 0x20) == 32) {
                    this.maxDynamicTableByteCount = n = this.readInt(n, 31);
                    if (n >= 0 && n <= this.headerTableSizeSetting) {
                        this.adjustDynamicTableByteCount();
                        continue;
                    }
                    throw new IOException(Intrinsics.stringPlus("Invalid dynamic table size update ", this.maxDynamicTableByteCount));
                }
                if (n != 16 && n != 0) {
                    Hpack$Reader hpack$Reader = this;
                    hpack$Reader.readLiteralHeaderWithoutIndexingIndexedName(hpack$Reader.readInt(n, 15) - 1);
                    continue;
                }
                this.readLiteralHeaderWithoutIndexingNewName();
                continue;
            }
            throw new IOException("index == 0");
        }
    }

    public final int readInt(int n, int n2) {
        int n3;
        if ((n &= n2) < n2) {
            return n;
        }
        n = 0;
        while (((n3 = this.readByte()) & 0x80) != 0) {
            n2 += (n3 & 0x7F) << n;
            n += 7;
        }
        return n2 + (n3 << n);
    }

    public final ByteString readByteString() {
        ByteString byteString;
        int n = this.readByte();
        boolean bl = (n & 0x80) == 128;
        long l = this.readInt(n, 127);
        if (bl) {
            Buffer buffer;
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            Huffman.INSTANCE.decode(this.source, l, buffer2);
            byteString = buffer.readByteString();
        } else {
            byteString = this.source.readByteString(l);
        }
        return byteString;
    }
}

