/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Hpack$Writer;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Http2Writer$Companion;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSink;

public final class Http2Writer
implements Closeable {
    public static final Http2Writer$Companion Companion = new Http2Writer$Companion(null);
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    private final Hpack$Writer hpackWriter;

    public Http2Writer(BufferedSink object, boolean bl) {
        Hpack$Writer hpack$Writer;
        Buffer buffer;
        Intrinsics.checkNotNullParameter(object, "sink");
        closeable.sink = object;
        closeable.client = bl;
        Closeable closeable = buffer;
        buffer = new Buffer();
        v1.hpackBuffer = closeable;
        v1.maxFrameSize = 16384;
        object = hpack$Writer;
        hpack$Writer = new Hpack$Writer(0, false, (Buffer)closeable, 3, null);
        v1.hpackWriter = object;
    }

    private final void writeContinuationFrames(int n, long l) {
        while (l > 0L) {
            long l2 = l;
            l = Math.min((long)this.maxFrameSize, l);
            long l3 = l2 - l;
            int n2 = (int)l;
            int n3 = 9;
            int n4 = l3 == 0L ? 4 : 0;
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(n, n2, n3, n4);
            http2Writer.sink.write(this.hpackBuffer, l);
            l = l3;
        }
    }

    public final synchronized void connectionPreface() {
        if (!this.closed) {
            if (!this.client) {
                return;
            }
            Logger logger = Http2Writer.logger;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format(Intrinsics.stringPlus(">> CONNECTION ", Http2.CONNECTION_PREFACE.hex()), new Object[0]));
            }
            Http2Writer http2Writer = this;
            http2Writer.sink.write(Http2.CONNECTION_PREFACE);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void applyAndAckSettings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "peerSettings");
        if (!this.closed) {
            this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
            if (settings.getHeaderTableSize() != -1) {
                this.hpackWriter.resizeHeaderTable(settings.getHeaderTableSize());
            }
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 0, 4, 1);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void pushPromise(int n, int n2, List list) {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.hpackWriter.writeHeaders(list);
            long l = http2Writer.hpackBuffer.size();
            int n3 = (int)Math.min((long)this.maxFrameSize - 4L, l);
            int n4 = n3 + 4;
            int n5 = 5;
            long l2 = n3;
            long l3 = l == l2 ? 0 : (l < l2 ? -1 : 1);
            int n6 = l3 == false ? 4 : 0;
            Http2Writer http2Writer2 = this;
            http2Writer2.frameHeader(n, n4, n5, n6);
            http2Writer2.sink.writeInt(n2 & Integer.MAX_VALUE);
            http2Writer2.sink.write(this.hpackBuffer, l2);
            if (l3 > 0) {
                long l4 = l - l2;
                this.writeContinuationFrames(n, l4);
            }
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void flush() {
        if (!this.closed) {
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void rstStream(int n, ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        if (!this.closed) {
            if (errorCode.getHttpCode() != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(n, 4, 3, 0);
                http2Writer.sink.writeInt(errorCode.getHttpCode());
                http2Writer.sink.flush();
                return;
            }
            throw new IllegalArgumentException("Failed requirement.".toString());
        }
        throw new IOException("closed");
    }

    public final int maxDataLength() {
        return this.maxFrameSize;
    }

    public final synchronized void data(boolean bl, int n, Buffer buffer, int n2) {
        if (!this.closed) {
            this.dataFrame(n, bl ? 1 : 0, buffer, n2);
            return;
        }
        throw new IOException("closed");
    }

    public final void dataFrame(int n, int n2, Buffer buffer, int n3) {
        this.frameHeader(n, n3, 0, n2);
        if (n3 > 0) {
            Intrinsics.checkNotNull(buffer);
            this.sink.write(buffer, n3);
        }
    }

    public final synchronized void settings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        if (!this.closed) {
            this.frameHeader(0, settings.size() * 6, 4, 0);
            int n = 0;
            while (n < 10) {
                int n2 = n;
                int n3 = n2 + 1;
                if (settings.isSet(n2)) {
                    int n4 = n != 4 ? (n != 7 ? n : 4) : 3;
                    Http2Writer http2Writer = this;
                    http2Writer.sink.writeShort(n4);
                    http2Writer.sink.writeInt(settings.get(n));
                }
                n = n3;
            }
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void ping(boolean bl, int n, int n2) {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 8, 6, bl ? 1 : 0);
            http2Writer.sink.writeInt(n);
            http2Writer.sink.writeInt(n2);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void goAway(int n, ErrorCode errorCode, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        Intrinsics.checkNotNullParameter(byArray, "debugData");
        if (!this.closed) {
            if (errorCode.getHttpCode() != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(0, byArray.length + 8, 7, 0);
                http2Writer.sink.writeInt(n);
                http2Writer.sink.writeInt(errorCode.getHttpCode());
                n = byArray.length == 0 ? 1 : 0;
                if ((n ^ 1) != 0) {
                    this.sink.write(byArray);
                }
                this.sink.flush();
                return;
            }
            throw new IllegalArgumentException("errorCode.httpCode == -1".toString());
        }
        throw new IOException("closed");
    }

    public final synchronized void windowUpdate(int n, long l) {
        if (!((Http2Writer)((Object)string)).closed) {
            if (l != 0L && l <= Integer.MAX_VALUE) {
                Http2Writer http2Writer = string;
                http2Writer.frameHeader(n, 4, 8, 0);
                http2Writer.sink.writeInt((int)l);
                http2Writer.sink.flush();
                return;
            }
            String string = Intrinsics.stringPlus("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: ", l);
            throw new IllegalArgumentException(string.toString());
        }
        throw new IOException("closed");
    }

    public final void frameHeader(int n, int n2, int n3, int n4) {
        Object object;
        Logger logger = Http2Writer.logger;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(false, n, n2, n3, n4));
        }
        if (n2 <= ((Http2Writer)object).maxFrameSize) {
            if ((n & Integer.MIN_VALUE) == 0) {
                Http2Writer http2Writer = object;
                Util.writeMedium(http2Writer.sink, n2);
                http2Writer.sink.writeByte(n3 & 0xFF);
                http2Writer.sink.writeByte(n4 & 0xFF);
                http2Writer.sink.writeInt(n & Integer.MAX_VALUE);
                return;
            }
            object = Intrinsics.stringPlus("reserved bit set: ", n);
            throw new IllegalArgumentException(object.toString());
        }
        object = "FRAME_SIZE_ERROR length > " + ((Http2Writer)object).maxFrameSize + ": " + n2;
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.sink.close();
    }

    public final synchronized void headers(boolean bl, int n, List list) {
        Intrinsics.checkNotNullParameter(list, "headerBlock");
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.hpackWriter.writeHeaders(list);
            long l = http2Writer.hpackBuffer.size();
            long l2 = Math.min((long)this.maxFrameSize, l);
            long l3 = l == l2 ? 0 : (l < l2 ? -1 : 1);
            int n2 = l3 == false ? 4 : 0;
            if (bl) {
                n2 |= 1;
            }
            Http2Writer http2Writer2 = this;
            http2Writer2.frameHeader(n, (int)l2, 1, n2);
            http2Writer2.sink.write(this.hpackBuffer, l2);
            if (l3 > 0) {
                long l4 = l - l2;
                this.writeContinuationFrames(n, l4);
            }
            return;
        }
        throw new IOException("closed");
    }
}

