/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.BasicCertificateChainCleaner$Companion;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    public static final BasicCertificateChainCleaner$Companion Companion = new BasicCertificateChainCleaner$Companion(null);
    private final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        Intrinsics.checkNotNullParameter(trustRootIndex, "trustRootIndex");
        this.trustRootIndex = trustRootIndex;
    }

    private final boolean verifySignature(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        boolean bl;
        if (!Intrinsics.areEqual(x509Certificate.getIssuerDN(), x509Certificate2.getSubjectDN())) {
            return false;
        }
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
            bl = true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public List clean(List arrayList, String object) {
        ArrayList arrayList2;
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter(arrayList, "chain");
        Intrinsics.checkNotNullParameter(object, "hostname");
        object = arrayDeque;
        arrayDeque = new ArrayDeque(arrayList);
        arrayList = arrayList2;
        arrayList();
        Object e = object.removeFirst();
        Intrinsics.checkNotNullExpressionValue(e, "queue.removeFirst()");
        arrayList2.add(e);
        boolean bl = false;
        int n = 0;
        block0: while (n < 9) {
            ArrayList<Object> arrayList3 = arrayList;
            ++n;
            X509Certificate x509Certificate = (X509Certificate)arrayList3.get(arrayList3.size() - 1);
            Object object2 = this.trustRootIndex.findByIssuerAndSignature(x509Certificate);
            if (object2 != null) {
                if (arrayList.size() > 1 || !Intrinsics.areEqual(x509Certificate, object2)) {
                    arrayList.add(object2);
                }
                Object object3 = object2;
                if (this.verifySignature((X509Certificate)object3, (X509Certificate)object3)) {
                    return arrayList;
                }
                bl = true;
                continue;
            }
            object2 = object.iterator();
            Intrinsics.checkNotNullExpressionValue(object2, "queue.iterator()");
            while (object2.hasNext()) {
                Object object4 = object2.next();
                if (object4 != null) {
                    if (!this.verifySignature(x509Certificate, (X509Certificate)(object4 = (X509Certificate)object4))) continue;
                    object2.remove();
                    arrayList.add(object4);
                    continue block0;
                }
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            if (bl) {
                return arrayList;
            }
            throw new SSLPeerUnverifiedException(Intrinsics.stringPlus("Failed to find a trusted cert that signed ", x509Certificate));
        }
        throw new SSLPeerUnverifiedException(Intrinsics.stringPlus("Certificate chain too long: ", arrayList));
    }

    public int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicCertificateChainCleaner)) return false;
        if (!Intrinsics.areEqual(((BasicCertificateChainCleaner)object).trustRootIndex, this.trustRootIndex)) return false;
        return true;
    }
}

