/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okio.Utf8;

public final class OkHostnameVerifier
implements HostnameVerifier {
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();

    private OkHostnameVerifier() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean verifyIpAddress(String object, X509Certificate x509Certificate) {
        OkHostnameVerifier okHostnameVerifier = string;
        String string = HostnamesKt.toCanonicalHost((String)object);
        object = okHostnameVerifier.getSubjectAltNames(x509Certificate, 7);
        if (object instanceof Collection && object.isEmpty()) {
            return false;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return false;
        } while (!Intrinsics.areEqual(string, HostnamesKt.toCanonicalHost((String)object.next())));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean verifyHostname(String object, X509Certificate object2) {
        OkHostnameVerifier okHostnameVerifier = string;
        String string = ((OkHostnameVerifier)((Object)string)).asciiToLowercase((String)object);
        object = okHostnameVerifier.getSubjectAltNames((X509Certificate)object2, 2);
        if (object instanceof Collection && object.isEmpty()) {
            return false;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return false;
        } while (!INSTANCE.verifyHostname(string, (String)(object2 = (String)object.next())));
        return true;
    }

    private final String asciiToLowercase(String string) {
        if (((OkHostnameVerifier)((Object)locale)).isAscii(string)) {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue(locale, "US");
            string = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(locale)");
        }
        return string;
    }

    private final boolean isAscii(String string) {
        return string.length() == (int)Utf8.size$default(string, 0, 0, 3, null);
    }

    private final boolean verifyHostname(String string, String string2) {
        if (!(string == null || string.length() == 0 || StringsKt.startsWith$default(string, ".", false, 2, null) || StringsKt.endsWith$default(string, "..", false, 2, null))) {
            if (!(string2 == null || string2.length() == 0 || StringsKt.startsWith$default(string2, ".", false, 2, null) || StringsKt.endsWith$default(string2, "..", false, 2, null))) {
                if (!StringsKt.endsWith$default(string, ".", false, 2, null)) {
                    string = Intrinsics.stringPlus(string, ".");
                }
                if (!StringsKt.endsWith$default(string2, ".", false, 2, null)) {
                    string2 = Intrinsics.stringPlus(string2, ".");
                }
                if (!StringsKt.contains$default((CharSequence)(object = ((OkHostnameVerifier)object).asciiToLowercase(string2)), "*", false, 2, null)) {
                    return Intrinsics.areEqual(string, object);
                }
                if (StringsKt.startsWith$default((String)object, "*.", false, 2, null) && StringsKt.indexOf$default((CharSequence)object, '*', 1, false, 4, null) == -1) {
                    if (string.length() < ((String)object).length()) {
                        return false;
                    }
                    if (Intrinsics.areEqual("*.", object)) {
                        return false;
                    }
                    Object object = ((String)object).substring(1);
                    Intrinsics.checkNotNullExpressionValue(object, "this as java.lang.String).substring(startIndex)");
                    if (!StringsKt.endsWith$default(string, (String)object, false, 2, null)) {
                        return false;
                    }
                    int n = string.length() - ((String)object).length();
                    return n <= 0 || StringsKt.lastIndexOf$default((CharSequence)string, '.', n - 1, false, 4, null) == -1;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List getSubjectAltNames(X509Certificate iterator2, int n) {
        List list;
        ArrayList arrayList;
        Object object = ((X509Certificate)((Object)iterator2)).getSubjectAlternativeNames();
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object object2 = object;
        object = arrayList;
        try {
            arrayList = new ArrayList();
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                list = (List)iterator2.next();
                if (list == null) continue;
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            return CollectionsKt.emptyList();
        }
        {
            Object e;
            if (list.size() < 2 || !Intrinsics.areEqual(list.get(0), n) || (e = list.get(1)) == null) continue;
            object.add((String)e);
            continue;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verify(String string, SSLSession object) {
        block6: {
            Intrinsics.checkNotNullParameter(string, "host");
            Intrinsics.checkNotNullParameter(object, "session");
            if (!this.isAscii(string)) {
                return false;
            }
            try {
                object = object.getPeerCertificates()[0];
                if (object == null) break block6;
            }
            catch (SSLException sSLException) {
                return false;
            }
            return this.verify(string, (X509Certificate)object);
        }
        throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
    }

    public final boolean verify(String string, X509Certificate x509Certificate) {
        Intrinsics.checkNotNullParameter(string, "host");
        Intrinsics.checkNotNullParameter(x509Certificate, "certificate");
        return Util.canParseAsIpAddress(string) ? this.verifyIpAddress(string, x509Certificate) : this.verifyHostname(string, x509Certificate);
    }

    public final List allSubjectAltNames(X509Certificate x509Certificate) {
        X509Certificate x509Certificate2 = x509Certificate;
        Intrinsics.checkNotNullParameter(x509Certificate2, "certificate");
        return CollectionsKt.plus((Collection)this.getSubjectAltNames(x509Certificate2, 7), (Iterable)this.getSubjectAltNames(x509Certificate, 2));
    }
}

