/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.Path$Companion;
import okio.internal._PathKt;

public final class Path
implements Comparable {
    public static final Path$Companion Companion = new Path$Companion(null);
    public static final String DIRECTORY_SEPARATOR;
    private final ByteString bytes;

    public Path(ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "bytes");
        this.bytes = byteString;
    }

    static {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue(string, "separator");
        DIRECTORY_SEPARATOR = string;
    }

    public final ByteString getBytes$okio() {
        return this.bytes;
    }

    public final Path getRoot() {
        Path path;
        int n = _PathKt.access$rootLength(path);
        if (n == -1) {
            path = null;
        } else {
            Path path2;
            Path path3 = path2;
            path2 = new Path(path.getBytes$okio().substring(0, n));
            path = path3;
        }
        return path;
    }

    public final List getSegments() {
        ArrayList arrayList;
        ArrayList<ByteString> arrayList2;
        Object object = arrayList2;
        arrayList2 = new ArrayList<ByteString>();
        int n = _PathKt.access$rootLength((Path)((Object)arrayList3));
        if (n == -1) {
            n = 0;
        } else if (n < ((Path)((Object)arrayList3)).getBytes$okio().size() && ((Path)((Object)arrayList3)).getBytes$okio().getByte(n) == (byte)92) {
            ++n;
        }
        int n2 = ((Path)((Object)arrayList3)).getBytes$okio().size();
        int n3 = n;
        while (n < n2) {
            if (((Path)((Object)arrayList3)).getBytes$okio().getByte(n) == (byte)47 || ((Path)((Object)arrayList3)).getBytes$okio().getByte(n) == (byte)92) {
                object.add(((Path)((Object)arrayList3)).getBytes$okio().substring(n3, n));
                n3 = n + 1;
            }
            ++n;
        }
        if (n3 < ((Path)((Object)arrayList3)).getBytes$okio().size()) {
            object.add(((Path)((Object)arrayList3)).getBytes$okio().substring(n3, ((Path)((Object)arrayList3)).getBytes$okio().size()));
        }
        ArrayList arrayList3 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList3.add(((ByteString)object.next()).utf8());
        }
        return arrayList3;
    }

    public final List getSegmentsBytes() {
        ArrayList<ByteString> arrayList;
        ArrayList<ByteString> arrayList2 = arrayList;
        arrayList = new ArrayList<ByteString>();
        int n = _PathKt.access$rootLength(this);
        if (n == -1) {
            n = 0;
        } else if (n < this.getBytes$okio().size() && this.getBytes$okio().getByte(n) == (byte)92) {
            ++n;
        }
        int n2 = this.getBytes$okio().size();
        int n3 = n;
        while (n < n2) {
            if (this.getBytes$okio().getByte(n) == (byte)47 || this.getBytes$okio().getByte(n) == (byte)92) {
                arrayList2.add(this.getBytes$okio().substring(n3, n));
                n3 = n + 1;
            }
            ++n;
        }
        if (n3 < this.getBytes$okio().size()) {
            arrayList2.add(this.getBytes$okio().substring(n3, this.getBytes$okio().size()));
        }
        return arrayList2;
    }

    public final boolean isAbsolute() {
        return _PathKt.access$rootLength(this) != -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Character volumeLetter() {
        char c;
        block3: {
            block2: {
                if (ByteString.indexOf$default(this.getBytes$okio(), _PathKt.access$getSLASH$p(), 0, 2, null) != -1) return null;
                if (this.getBytes$okio().size() < 2 || this.getBytes$okio().getByte(1) != (byte)58) break block2;
                c = (char)this.getBytes$okio().getByte(0);
                if ('a' <= c && c < '{') break block3;
                if ('A' > c) return null;
                if (c >= '[') return null;
                boolean bl = true;
                if (bl) break block3;
            }
            return null;
        }
        Character c2 = Character.valueOf(c);
        return c2;
    }

    public final ByteString nameBytes() {
        int n = _PathKt.access$getIndexOfLastSlash(this);
        return n != -1 ? ByteString.substring$default(this.getBytes$okio(), n + 1, 0, 2, null) : (this.volumeLetter() != null && this.getBytes$okio().size() == 2 ? ByteString.EMPTY : this.getBytes$okio());
    }

    public final String name() {
        return this.nameBytes().utf8();
    }

    public final Path parent() {
        block6: {
            Path path;
            block4: {
                int n;
                block7: {
                    Path path2;
                    block5: {
                        Path path3;
                        if (Intrinsics.areEqual(path.getBytes$okio(), _PathKt.access$getDOT$p()) || Intrinsics.areEqual(path.getBytes$okio(), _PathKt.access$getSLASH$p()) || Intrinsics.areEqual(path.getBytes$okio(), _PathKt.access$getBACKSLASH$p()) || _PathKt.access$lastSegmentIsDotDot(path)) break block4;
                        n = _PathKt.access$getIndexOfLastSlash(path);
                        if (n != 2 || path.volumeLetter() == null) break block5;
                        if (path.getBytes$okio().size() == 3) break block4;
                        Path path4 = path3;
                        path3 = new Path(ByteString.substring$default(path.getBytes$okio(), 0, 3, 1, null));
                        path = path4;
                        break block6;
                    }
                    if (n == 1 && path.getBytes$okio().startsWith(_PathKt.access$getBACKSLASH$p())) break block4;
                    if (n != -1 || path.volumeLetter() == null) break block7;
                    if (path.getBytes$okio().size() == 2) break block4;
                    Path path5 = path2;
                    path2 = new Path(ByteString.substring$default(path.getBytes$okio(), 0, 2, 1, null));
                    path = path5;
                    break block6;
                }
                if (n == -1) {
                    Path path6;
                    path = path6;
                    path6 = new Path(_PathKt.access$getDOT$p());
                } else if (n == 0) {
                    Path path7;
                    Path path8 = path7;
                    path7 = new Path(ByteString.substring$default(path.getBytes$okio(), 0, 1, 1, null));
                    path = path8;
                } else {
                    Path path9;
                    Path path10 = path9;
                    path9 = new Path(ByteString.substring$default(path.getBytes$okio(), 0, n, 1, null));
                    path = path10;
                }
                break block6;
            }
            path = null;
        }
        return path;
    }

    public final Path resolve(String string) {
        Intrinsics.checkNotNullParameter(string, "child");
        return _PathKt.commonResolve(this, _PathKt.toPath(new Buffer().writeUtf8(string), false), false);
    }

    public final Path resolve(String string, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "child");
        return _PathKt.commonResolve(this, _PathKt.toPath(new Buffer().writeUtf8(string), false), bl);
    }

    public final Path resolve(Path path, boolean bl) {
        Path path2 = path;
        Intrinsics.checkNotNullParameter(path2, "child");
        return _PathKt.commonResolve(this, path2, bl);
    }

    public final Path relativeTo(Path object) {
        Object object2;
        block7: {
            block10: {
                Path path;
                block9: {
                    Buffer buffer;
                    int n;
                    List list;
                    List list2;
                    block8: {
                        Intrinsics.checkNotNullParameter(object, "other");
                        if (!Intrinsics.areEqual(((Path)object2).getRoot(), ((Path)object).getRoot())) break block7;
                        list2 = ((Path)object2).getSegmentsBytes();
                        list = ((Path)object).getSegmentsBytes();
                        int n2 = Math.min(list2.size(), list.size());
                        for (n = 0; n < n2 && Intrinsics.areEqual(list2.get(n), list.get(n)); ++n) {
                        }
                        if (n != n2 || ((Path)object2).getBytes$okio().size() != ((Path)object).getBytes$okio().size()) break block8;
                        path = Path$Companion.get$default(Companion, ".", false, 1, null);
                        break block9;
                    }
                    if (!(list.subList(n, list.size()).indexOf(_PathKt.access$getDOT_DOT$p()) == -1)) break block10;
                    Path path2 = object;
                    object = buffer;
                    buffer = new Buffer();
                    ByteString byteString = _PathKt.access$getSlash(path2);
                    if (byteString == null && (byteString = _PathKt.access$getSlash((Path)object2)) == null) {
                        byteString = _PathKt.access$toSlash(DIRECTORY_SEPARATOR);
                    }
                    int n3 = list.size();
                    for (int i = n; i < n3; ++i) {
                        ((Buffer)object).write(_PathKt.access$getDOT_DOT$p());
                        ((Buffer)object).write(byteString);
                    }
                    n3 = list2.size();
                    while (n < n3) {
                        ((Buffer)object).write((ByteString)list2.get(n));
                        ((Buffer)object).write(byteString);
                        ++n;
                    }
                    path = _PathKt.toPath((Buffer)object, false);
                }
                return path;
            }
            object2 = "Impossible relative path to resolve: " + object2 + " and " + object;
            throw new IllegalArgumentException(object2.toString());
        }
        object2 = "Paths of different roots cannot be relative to each other: " + object2 + " and " + object;
        throw new IllegalArgumentException(object2.toString());
    }

    public final File toFile() {
        return new File(this.toString());
    }

    public final java.nio.file.Path toNioPath() {
        java.nio.file.Path path = Paths.get(this.toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(toString())");
        return path;
    }

    public int compareTo(Path path) {
        Intrinsics.checkNotNullParameter(path, "other");
        return this.getBytes$okio().compareTo(path.getBytes$okio());
    }

    public boolean equals(Object object) {
        return object instanceof Path && Intrinsics.areEqual(((Path)object).getBytes$okio(), this.getBytes$okio());
    }

    public int hashCode() {
        return this.getBytes$okio().hashCode();
    }

    public String toString() {
        return this.getBytes$okio().utf8();
    }
}

