/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import okio._UtilKt;
import okio.internal._SegmentedByteStringKt;

public final class SegmentedByteString
extends ByteString {
    private final transient byte[][] segments;
    private final transient int[] directory;

    public SegmentedByteString(byte[][] byArray, int[] nArray) {
        Intrinsics.checkNotNullParameter(byArray, "segments");
        Intrinsics.checkNotNullParameter(nArray, "directory");
        super(ByteString.EMPTY.getData$okio());
        this.segments = byArray;
        this.directory = nArray;
    }

    private final ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    public final byte[][] getSegments$okio() {
        return this.segments;
    }

    public final int[] getDirectory$okio() {
        return this.directory;
    }

    @Override
    public String string(Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        return this.toByteString().string(charset);
    }

    @Override
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    public ByteString digest$okio(String object) {
        String string = object;
        Intrinsics.checkNotNullParameter(string, "algorithm");
        object = MessageDigest.getInstance(string);
        int n = ((SegmentedByteString)object2).getSegments$okio().length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SegmentedByteString segmentedByteString = object2;
            int n3 = segmentedByteString.getDirectory$okio()[n + i];
            int n4 = segmentedByteString.getDirectory$okio()[i];
            byte[] byArray = ((SegmentedByteString)object2).getSegments$okio()[i];
            int n5 = n4 - n2;
            ((MessageDigest)object).update(byArray, n3, n5);
            n2 = n4;
        }
        Object object2 = ((MessageDigest)object).digest();
        Intrinsics.checkNotNullExpressionValue(object2, "digestBytes");
        return new ByteString((byte[])object2);
    }

    @Override
    public ByteString substring(int n, int n2) {
        Object object;
        n2 = _UtilKt.resolveDefaultParameter((ByteString)object, n2);
        if (n >= 0) {
            if (n2 <= ((ByteString)object).size()) {
                int n3 = n2 - n;
                if (n3 >= 0) {
                    if (n != 0 || n2 != ((ByteString)object).size()) {
                        if (n == n2) {
                            object = ByteString.EMPTY;
                        } else {
                            SegmentedByteString segmentedByteString;
                            int n4 = _SegmentedByteStringKt.segment((SegmentedByteString)object, n);
                            n2 = _SegmentedByteStringKt.segment((SegmentedByteString)object, n2 - 1);
                            byte[][] byArray = (byte[][])ArraysKt.copyOfRange((Object[])((SegmentedByteString)object).getSegments$okio(), n4, n2 + 1);
                            int[] nArray = new int[byArray.length * 2];
                            int n5 = 0;
                            if (n4 <= n2) {
                                int n6 = n4;
                                while (true) {
                                    int n7 = n5;
                                    nArray[n5] = Math.min(((SegmentedByteString)object).getDirectory$okio()[n6] - n, n3);
                                    ++n5;
                                    nArray[n7 + byArray.length] = ((SegmentedByteString)object).getDirectory$okio()[n6 + ((SegmentedByteString)object).getSegments$okio().length];
                                    if (n6 == n2) break;
                                    ++n6;
                                }
                            }
                            int n8 = n4 == 0 ? 0 : ((SegmentedByteString)object).getDirectory$okio()[n4 - 1];
                            n2 = byArray.length;
                            nArray[n2] = nArray[n2] + (n - n8);
                            object = segmentedByteString;
                            segmentedByteString = new SegmentedByteString(byArray, nArray);
                        }
                    }
                    return object;
                }
                object = "endIndex=" + n2 + " < beginIndex=" + n;
                throw new IllegalArgumentException(object.toString());
            }
            object = "endIndex=" + n2 + " > length(" + ((ByteString)object).size() + ')';
            throw new IllegalArgumentException(object.toString());
        }
        object = "beginIndex=" + n + " < 0";
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public byte internalGet$okio(int n) {
        _UtilKt.checkOffsetAndCount(this.getDirectory$okio()[this.getSegments$okio().length - 1], n, 1L);
        int n2 = _SegmentedByteStringKt.segment(this, n);
        int n3 = n2 == 0 ? 0 : this.getDirectory$okio()[n2 - 1];
        SegmentedByteString segmentedByteString = this;
        int n4 = segmentedByteString.getDirectory$okio()[n2 + this.getSegments$okio().length];
        return segmentedByteString.getSegments$okio()[n2][n - n3 + n4];
    }

    @Override
    public int getSize$okio() {
        return this.getDirectory$okio()[this.getSegments$okio().length - 1];
    }

    public byte[] toByteArray() {
        SegmentedByteString segmentedByteString = this;
        byte[] byArray = new byte[segmentedByteString.size()];
        int n = 0;
        int n2 = segmentedByteString.getSegments$okio().length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            SegmentedByteString segmentedByteString2 = this;
            int n4 = segmentedByteString2.getDirectory$okio()[n2 + i];
            int n5 = segmentedByteString2.getDirectory$okio()[i];
            n3 = n5 - n3;
            int n6 = n4 + n3;
            ArraysKt.copyInto(segmentedByteString2.getSegments$okio()[i], byArray, n, n4, n6);
            n += n3;
            n3 = n5;
        }
        return byArray;
    }

    @Override
    public void write$okio(Buffer buffer, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        int n3 = n + n2;
        int n4 = _SegmentedByteStringKt.segment(this, n);
        while (n < n3) {
            Segment segment;
            int n5 = n4 == 0 ? 0 : this.getDirectory$okio()[n4 - 1];
            SegmentedByteString segmentedByteString = this;
            int n6 = segmentedByteString.getDirectory$okio()[n4] - n5;
            int n7 = n5;
            n5 = Math.min(n3, n5 + n6) - n;
            n6 = segmentedByteString.getDirectory$okio()[this.getSegments$okio().length + n4] + (n - n7);
            byte[] byArray = segmentedByteString.getSegments$okio()[n4];
            Segment segment2 = segment;
            segment = new Segment(byArray, n6, n6 + n5, true, false);
            Segment segment3 = buffer.head;
            if (segment3 == null) {
                segment2.prev = segment2;
                segment2.next = segment2;
                buffer.head = segment2;
            } else {
                Segment segment4 = segment3;
                Intrinsics.checkNotNull(segment4);
                Segment segment5 = segment4.prev;
                Intrinsics.checkNotNull(segment5);
                segment5.push(segment2);
            }
            n += n5;
            ++n4;
        }
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + (long)n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean rangeEquals(int n, ByteString byteString, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        if (n < 0) return false;
        if (n > this.size() - n3) return false;
        n3 = n + n3;
        int n4 = _SegmentedByteStringKt.segment(this, n);
        while (n < n3) {
            int n5 = n4 == 0 ? 0 : this.getDirectory$okio()[n4 - 1];
            SegmentedByteString segmentedByteString = this;
            int n6 = segmentedByteString.getDirectory$okio()[n4] - n5;
            int n7 = n5;
            n5 = Math.min(n3, n5 + n6) - n;
            n6 = segmentedByteString.getDirectory$okio()[this.getSegments$okio().length + n4] + (n - n7);
            if (!byteString.rangeEquals(n2, segmentedByteString.getSegments$okio()[n4], n6, n5)) return false;
            n2 += n5;
            n += n5;
            ++n4;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean rangeEquals(int n, byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        if (n < 0) return false;
        if (n > this.size() - n3) return false;
        if (n2 < 0) return false;
        if (n2 > byArray.length - n3) return false;
        n3 = n + n3;
        int n4 = _SegmentedByteStringKt.segment(this, n);
        while (n < n3) {
            int n5 = n4 == 0 ? 0 : this.getDirectory$okio()[n4 - 1];
            SegmentedByteString segmentedByteString = this;
            int n6 = segmentedByteString.getDirectory$okio()[n4] - n5;
            int n7 = n5;
            n5 = Math.min(n3, n5 + n6) - n;
            n6 = segmentedByteString.getDirectory$okio()[this.getSegments$okio().length + n4] + (n - n7);
            if (!_UtilKt.arrayRangeEquals(segmentedByteString.getSegments$okio()[n4], n6, byArray, n2, n5)) return false;
            n2 += n5;
            n += n5;
            ++n4;
        }
        return true;
    }

    @Override
    public int indexOf(byte[] byArray, int n) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        return this.toByteString().indexOf(byArray, n);
    }

    @Override
    public int lastIndexOf(byte[] byArray, int n) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        return this.toByteString().lastIndexOf(byArray, n);
    }

    @Override
    public byte[] internalArray$okio() {
        return this.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) return false;
        if (((ByteString)(object = (ByteString)object)).size() != this.size()) return false;
        SegmentedByteString segmentedByteString = this;
        int n = segmentedByteString.size();
        if (!segmentedByteString.rangeEquals(0, (ByteString)object, 0, n)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.getHashCode$okio();
        if (n == 0) {
            n = 1;
            int n2 = this.getSegments$okio().length;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4;
                int n5 = this.getDirectory$okio()[i];
                byte[] byArray = this.getSegments$okio()[i];
                int n6 = n4 + (n5 - n3);
                for (n4 = this.getDirectory$okio()[n2 + i]; n4 < n6; ++n4) {
                    n = n * 31 + byArray[n4];
                }
                n3 = n5;
            }
            this.setHashCode$okio(n);
        }
        return n;
    }

    @Override
    public String toString() {
        return this.toByteString().toString();
    }
}

